/*
 * Copyright (c) 2008-2011 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.util;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

import org.apache.commons.collections.CollectionUtils;

/**
 * Provides a number of utility methods for {@link Set}s.
 */
public class SetUtils {

	/**
	 * Subtracts one set from another.
	 * 
	 * @param <T>
	 *            the type of the objects in the sets.
	 * @param minuend
	 *            the set to subtract from
	 * @param subtrahend
	 *            the set to subtract
	 * @return the difference
	 */
	@SuppressWarnings("unchecked")
	public static <T> Set<T> subtract(Set<? extends T> minuend, Set<? extends T> subtrahend) {
		return new HashSet<T>(CollectionUtils.subtract(minuend, subtrahend));
	}

	/**
	 * Returns a variable number of arguments (or an array) as a set.
	 * 
	 * @param <T>
	 *            the type of the objects in the set.
	 * @param objs
	 *            the object to place in the set.
	 * @return the constructed set.
	 */
	public static <T> Set<T> asSet(T... objs) {
		return new HashSet<T>(Arrays.asList(objs));
	}

}
