/*
 * Copyright (c) 2008-2011 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.steps;

import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.StepExecutionContextCallbackHandler;
import com.xebialabs.deployit.ci.Database;
import com.xebialabs.deployit.ci.artifact.SqlFolder;
import com.xebialabs.deployit.ci.artifact.mapping.PlaceholderFormat;
import com.xebialabs.deployit.exception.RuntimeIOException;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.util.TemplateResolver;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@SuppressWarnings("serial")
public class RunSqlScriptWithUploadedScriptOnDatabaseStep extends AbstractDatabaseStep implements Step {
	private final File sqlFile;
	private final String relativeSqlFile;

	public RunSqlScriptWithUploadedScriptOnDatabaseStep(Database target, SqlFolder source, File sqlFile, Map<String, String> properties,
	        PlaceholderFormat placeholderFormat) {
		super(source, target, properties, placeholderFormat);
		this.sqlFile = sqlFile;
		this.relativeSqlFile = getRelativePath();
	}

	private String getRelativePath() {
		// location + relativePath = sqlFilePath
		return sqlFile.getAbsolutePath().substring(new File(source.getLocation()).getAbsolutePath().length() + 1);
	}

	public String getDescription() {
		return "Executing SQL Script " + this.sqlFile + " on " + database.getLabel();
	}

	public boolean execute(StepExecutionContext ctx) {
		HostSession s = getHostSession(ctx);
		try {
			final HostFile remoteSqlFile = getRemoteLocation(ctx).getFile(relativeSqlFile);

			final SqlErrorContextCallbackHandler handler = new SqlErrorContextCallbackHandler(ctx);

			int retCode = s.execute(handler, getSqlRunnerPath(ctx), remoteSqlFile.getPath());

			if (handler.hasErrors())
				throw new RuntimeException("SQL errors has been detected when running " + remoteSqlFile + ":" + handler.getErrors());

			return retCode == 0;

		} catch (RuntimeIOException exc) {
			throw new RuntimeIOException("Cannot execute remote command \"" + database.getCommand() + "\" on " + database.getHost(), exc);
		}
	}

	private String getResolvedOptions() {
		String unresolvedOptions = database.getOptions();
		Map<String, String> variables = new HashMap<String, String>();
		variables.put("user", database.getUser());
		variables.put("password", database.getPassword());
		variables.put("database", database.getDatabase());
		TemplateResolver resolver = new TemplateResolver(variables);
		String resolvedOptions = resolver.resolveLenient(unresolvedOptions);
		return resolvedOptions;
	}

	private class SqlErrorContextCallbackHandler extends StepExecutionContextCallbackHandler {

		private final List<String> errors = new ArrayList<String>();

		public SqlErrorContextCallbackHandler(StepExecutionContext ctx) {
			super(ctx);
		}

		@Override
		public void handleOutputLine(String line) {
			super.handleOutputLine(line);
			errorHandler(line);
		}

		@Override
		public void handleErrorLine(String line) {
			super.handleErrorLine(line);
			errorHandler(line);
		}

		private void errorHandler(String line) {
			if (line.startsWith("ERROR"))
				errors.add(line);
		}

		public boolean hasErrors() {
			return !errors.isEmpty();
		}

		public String getErrors() {
			return errors.toString();
		}
	}
}
