/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.steps;

import com.xebialabs.deployit.ResolutionException;
import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.ci.Host;
import com.xebialabs.deployit.ci.artifact.mapping.PlaceholderFormat;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostFileInputStreamTransformer;
import com.xebialabs.deployit.hostsession.HostFileUtils;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.hostsession.HostSessionFactory;
import com.xebialabs.deployit.hostsession.LenientTemplateResolvingArchiveHostFileInputTransformer;
import com.xebialabs.deployit.steps.HostSessionStep;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class CopyStep
extends HostSessionStep {
    protected String sourceLocation;
    protected String destinationLocation;
    protected Host destinationHost;
    protected Map<String, String> properties;
    protected PlaceholderFormat placeholderFormat;
    private boolean createToplevelDirectory;

    public CopyStep(Host sourceHost, String sourceLocation, Host destinationHost, String destinationLocation) {
        this(sourceHost, sourceLocation, destinationHost, destinationLocation, null);
    }

    public CopyStep(Host sourceHost, String sourceLocation, Host destinationHost, String destinationLocation, Map<String, String> properties) {
        this(sourceHost, sourceLocation, destinationHost, destinationLocation, properties, PlaceholderFormat.SPRING);
    }

    public CopyStep(Host sourceHost, String sourceLocation, Host destinationHost, String destinationLocation, Map<String, String> properties, PlaceholderFormat placeholderFormat) {
        super(sourceHost);
        if (StringUtils.isEmpty((String)sourceLocation)) {
            throw new ResolutionException("No source location specified");
        }
        if (StringUtils.isEmpty((String)destinationLocation)) {
            throw new ResolutionException("No destination location specified");
        }
        this.sourceLocation = sourceLocation;
        this.destinationLocation = destinationLocation;
        this.destinationHost = destinationHost;
        this.properties = properties;
        this.placeholderFormat = placeholderFormat;
        String description = "Copy " + sourceLocation + " from " + sourceHost + " to " + destinationLocation + " on " + destinationHost;
        if (this.properties != null && !properties.isEmpty()) {
            description = description + " while replacing property values using " + placeholderFormat + " placeholder format";
        }
        this.setDescription(description);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(StepExecutionContext ctx) {
        HostSession sourceSession = this.getHostSession();
        HostSession destinationSession = HostSessionFactory.getHostSession(this.destinationHost);
        try {
            HostFile sourceFile = sourceSession.getFile(this.sourceLocation);
            HostFile destinationFile = destinationSession.getFile(this.destinationLocation);
            if (this.createToplevelDirectory && !destinationFile.exists()) {
                if (sourceFile.isDirectory()) {
                    ctx.logOutput("Creating destination directory " + destinationFile);
                    destinationFile.mkdirs();
                } else {
                    HostFile parentFile = destinationFile.getParentFile();
                    ctx.logOutput("Creating destination directory " + parentFile);
                    parentFile.mkdirs();
                }
            }
            HostFileUtils.copy(sourceFile, destinationFile, this.getTransformer());
            boolean bl = true;
            return bl;
        }
        finally {
            sourceSession.close();
            destinationSession.close();
        }
    }

    protected HostFileInputStreamTransformer getTransformer() {
        if (this.properties == null) {
            return null;
        }
        if (this.properties.isEmpty()) {
            return null;
        }
        return new LenientTemplateResolvingArchiveHostFileInputTransformer(this.properties, this.placeholderFormat);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CopyStep)) {
            return false;
        }
        CopyStep copyStep = (CopyStep)o;
        if (!this.destinationHost.equals(copyStep.destinationHost)) {
            return false;
        }
        if (!this.destinationLocation.equals(copyStep.destinationLocation)) {
            return false;
        }
        if (this.properties != null ? !((Object)this.properties).equals(copyStep.properties) : copyStep.properties != null) {
            return false;
        }
        return this.sourceLocation.equals(copyStep.sourceLocation);
    }

    public int hashCode() {
        int result = this.sourceLocation.hashCode();
        result = 31 * result + this.destinationLocation.hashCode();
        result = 31 * result + this.destinationHost.hashCode();
        result = 31 * result + (this.properties != null ? ((Object)this.properties).hashCode() : 0);
        return result;
    }

    public boolean isCreateToplevelDirectory() {
        return this.createToplevelDirectory;
    }

    public void setCreateToplevelDirectory(boolean createToplevelDirectory) {
        this.createToplevelDirectory = createToplevelDirectory;
    }
}

