/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.reflect;

import com.qrmedia.commons.lang.ClassUtils;
import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemDescription;
import com.xebialabs.deployit.ConfigurationItemLabel;
import com.xebialabs.deployit.ConfigurationItemPermissionScheme;
import com.xebialabs.deployit.ConfigurationItemPlaceholderFormat;
import com.xebialabs.deployit.ConfigurationItemPlaceholders;
import com.xebialabs.deployit.ConfigurationItemRoot;
import com.xebialabs.deployit.Discoverable;
import com.xebialabs.deployit.ci.artifact.mapping.DeployableArtifactMapping;
import com.xebialabs.deployit.ci.artifact.mapping.PlaceholderFormat;
import com.xebialabs.deployit.ci.mapping.Mapping;
import com.xebialabs.deployit.ci.security.PermissionScheme;
import com.xebialabs.deployit.reflect.ConfigurationItemPropertyDescriptor;
import com.xebialabs.deployit.reflect.ConfigurationItemPropertyHolder;
import com.xebialabs.deployit.reflect.ConfigurationItemReflectionUtils;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ConfigurationItemDescriptor
implements Serializable,
Comparable<ConfigurationItemDescriptor>,
ConfigurationItemPropertyHolder {
    private String type;
    private transient Class<?> typeClass;
    private String simpleName;
    private Set<String> interfaces = new HashSet<String>();
    private List<String> superClasses = new ArrayList<String>();
    private String mappingSourceType;
    private String mappingTargetType;
    private String description;
    private ConfigurationItemPropertyDescriptor[] propertyDescriptors = new ConfigurationItemPropertyDescriptor[0];
    private String labelPropertyName;
    private transient Field labelPropertyField;
    private String descriptionPropertyName;
    private transient Field descriptionPropertyField;
    private String permissionSchemePropertyName;
    private transient Field permissionSchemePropertyField;
    private String defaultDescription;
    private String defaultPermissionSchemeLabel;
    private String category;
    private ConfigurationItemRoot root;
    private boolean discoverable = false;
    private String placeholderFormatName;
    private transient Field placeholderFormatField;
    private String placeholdersName;
    private transient Field placeholdersField;

    public ConfigurationItemDescriptor() {
    }

    public ConfigurationItemDescriptor(Class<?> typeClass, Map<String, String> configuredDefaults) {
        this.initTypeInfo(typeClass);
        ConfigurationItem ciAnnotation = typeClass.getAnnotation(ConfigurationItem.class);
        this.initDescription(ciAnnotation);
        String defaultValueKeyPrefix = typeClass.getSimpleName().toLowerCase() + ".";
        this.initProperties(typeClass, configuredDefaults, defaultValueKeyPrefix);
        this.initBuiltinProperties(typeClass);
        this.initDefaults(configuredDefaults, defaultValueKeyPrefix);
        this.initMetaProperties(ciAnnotation);
        if (ciAnnotation.discoverable() && !Discoverable.class.isAssignableFrom(typeClass)) {
            throw new IllegalArgumentException("CI type " + this.type + " has set CI meta property 'discoverable' to true, but does not implement the Discoverable interface");
        }
    }

    private void initBuiltinProperties(Class<?> typeClass) {
        this.initLabelProperty(typeClass);
        this.initDescriptionProperty(typeClass);
        this.initPermissionSchemeProperty(typeClass);
        this.initPlaceholders(typeClass);
    }

    private void initPlaceholders(Class<?> typeClass) {
        Field placeholderProperties = ConfigurationItemPropertyDescriptor.getSingleAnnotatedProperty(typeClass, ConfigurationItemPlaceholders.class, "CI type " + this.type + " defines more than one field with the @ConfigurationItemPlaceholders annotation");
        Field placeholderFormat = ConfigurationItemPropertyDescriptor.getSingleAnnotatedProperty(typeClass, ConfigurationItemPlaceholderFormat.class, "CI type " + this.type + " defines more than one field with the @ConfigurationItemPlaceholderFormat annotation");
        if (placeholderProperties != null && !DeployableArtifactMapping.class.isAssignableFrom(typeClass)) {
            throw new IllegalArgumentException("Placeholders can only be present on a DeployableArtifactMapping or subtype, not on " + typeClass);
        }
        if (placeholderProperties != null) {
            this.setPlaceholdersField(placeholderProperties, placeholderFormat);
        }
    }

    private void setPlaceholdersField(Field placeholderProperties, Field placeholderFormat) {
        if (placeholderFormat != null && !placeholderFormat.getType().equals(PlaceholderFormat.class)) {
            throw new IllegalArgumentException("Property " + placeholderFormat.getName() + " of class " + this.descriptionPropertyField.getDeclaringClass().getName() + " is annotated with the @ConfigurationItemPlaceholderFormat annotation but is not a PlaceholderFormat enum");
        }
        if (placeholderFormat != null) {
            placeholderFormat.setAccessible(true);
            this.placeholderFormatField = placeholderFormat;
            this.placeholderFormatName = placeholderFormat.getName();
        }
        if (!placeholderProperties.getType().equals(List.class)) {
            throw new IllegalArgumentException("Property " + placeholderProperties.getName() + " of class " + this.descriptionPropertyField.getDeclaringClass().getName() + " is annotated with the @ConfigurationItemPlaceholderFormat annotation but is not a Placeholders");
        }
        placeholderProperties.setAccessible(true);
        this.placeholdersField = placeholderProperties;
        this.placeholdersName = placeholderProperties.getName();
    }

    private void initLabelProperty(Class<?> typeClass) {
        Field labelProperty = ConfigurationItemPropertyDescriptor.getSingleAnnotatedProperty(typeClass, ConfigurationItemLabel.class, "CI type " + this.type + " defines more than one property with the @ConfigurationItemLabel annotation");
        if (labelProperty != null) {
            this.setLabelPropertyField(labelProperty);
        }
    }

    private void initDescriptionProperty(Class<?> typeClass) {
        Field descriptionProperty = ConfigurationItemPropertyDescriptor.getSingleAnnotatedProperty(typeClass, ConfigurationItemDescription.class, "CI type " + this.type + " defines more than one property with the @ConfigurationItemDescription annotation");
        if (descriptionProperty != null) {
            this.setDescriptionPropertyField(descriptionProperty);
        }
    }

    private void initPermissionSchemeProperty(Class<? extends Object> typeClass) {
        Field permissionSchemeProperty = ConfigurationItemPropertyDescriptor.getSingleAnnotatedProperty(typeClass, ConfigurationItemPermissionScheme.class, "CI type " + this.type + " defines more than one property with the @ConfigurationItemPermissionScheem annotation");
        if (permissionSchemeProperty != null) {
            this.setPermissionSchemePropertyField(permissionSchemeProperty);
        }
    }

    private void initTypeInfo(Class<?> typeClass) {
        this.typeClass = typeClass;
        this.type = typeClass.getName();
        this.simpleName = typeClass.getSimpleName();
        for (Class each : org.apache.commons.lang.ClassUtils.getAllInterfaces(typeClass)) {
            this.interfaces.add(each.getName());
        }
        List allSuperclasses = org.apache.commons.lang.ClassUtils.getAllSuperclasses(typeClass);
        for (Class each : allSuperclasses) {
            if (each == Object.class) continue;
            this.superClasses.add(each.getName());
        }
        if (Mapping.class.isAssignableFrom(typeClass)) {
            List actualTypeArguments = ClassUtils.getActualTypeArguments(typeClass, Mapping.class);
            this.mappingSourceType = actualTypeArguments.get(0) != null ? ((Class)actualTypeArguments.get(0)).getName() : Serializable.class.getName();
            this.mappingTargetType = actualTypeArguments.get(1) != null ? ((Class)actualTypeArguments.get(1)).getName() : Serializable.class.getName();
        }
    }

    private void initDescription(ConfigurationItem ciAnnotation) {
        this.description = ciAnnotation.description();
    }

    private void initProperties(Class<? extends Object> typeClass, Map<String, String> configuredDefaults, String defaultValueKeyPrefix) {
        this.propertyDescriptors = ConfigurationItemPropertyDescriptor.getConfigurationItemPropertyDescriptorsForTopLevelClass(this, typeClass, configuredDefaults, defaultValueKeyPrefix);
    }

    private void initDefaults(Map<String, String> configuredDefaults, String defaultValueKeyPrefix) {
        this.defaultDescription = configuredDefaults.get(defaultValueKeyPrefix + "description");
        this.defaultPermissionSchemeLabel = configuredDefaults.get(defaultValueKeyPrefix + "permissionscheme");
    }

    private void initMetaProperties(ConfigurationItem ciAnnotation) {
        this.category = ciAnnotation.category();
        this.root = ciAnnotation.root();
        this.discoverable = ciAnnotation.discoverable();
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Class<? extends Object> getTypeClass() {
        if (this.typeClass == null) {
            try {
                this.typeClass = Class.forName(this.type);
            }
            catch (ClassNotFoundException exc) {
                throw new RuntimeException("Cannot load class " + this.type, exc);
            }
        }
        return this.typeClass;
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    public void setSimpleName(String simpleName) {
        this.simpleName = simpleName;
    }

    public Object newInstance() {
        try {
            return this.typeClass.newInstance();
        }
        catch (Exception exception) {
            throw new AssertionError((Object)("Unable to instantiate type " + this.type + ": " + exception.getMessage()));
        }
    }

    @Override
    public ConfigurationItemPropertyDescriptor[] getPropertyDescriptors() {
        return this.propertyDescriptors;
    }

    @Override
    public ConfigurationItemPropertyDescriptor getPropertyDescriptor(String propertyName) {
        for (ConfigurationItemPropertyDescriptor each : this.propertyDescriptors) {
            if (!each.getName().equals(propertyName)) continue;
            return each;
        }
        return null;
    }

    public void setPropertyDescriptors(ConfigurationItemPropertyDescriptor[] propertyDescriptors) {
        this.propertyDescriptors = propertyDescriptors;
    }

    public String getLabelPropertyName() {
        return this.labelPropertyName;
    }

    public Field getLabelPropertyField() {
        return this.labelPropertyField;
    }

    public void setLabelPropertyName(String labelPropertyName) {
        this.labelPropertyName = labelPropertyName;
    }

    private void setLabelPropertyField(Field labelPropertyField) {
        if (!labelPropertyField.getType().equals(String.class)) {
            throw new IllegalArgumentException("Property " + labelPropertyField.getName() + " of class " + labelPropertyField.getDeclaringClass().getName() + " is annotated with the @ConfigurationItemLabel annotation but is not a String");
        }
        labelPropertyField.setAccessible(true);
        this.labelPropertyField = labelPropertyField;
        this.labelPropertyName = labelPropertyField.getName();
    }

    public String getLabelValueFromConfigurationItem(Object configurationItem) {
        configurationItem = ConfigurationItemReflectionUtils.getRealConfigurationItem(configurationItem);
        return (String)this.getFieldValueOrReturnNull(this.labelPropertyField, configurationItem);
    }

    public void setLabelValueInConfigurationItem(Object configurationItem, String labelValue) {
        configurationItem = ConfigurationItemReflectionUtils.getRealConfigurationItem(configurationItem);
        this.setFieldValue(this.labelPropertyField, configurationItem, labelValue);
    }

    public String getDescriptionPropertyName() {
        return this.descriptionPropertyName;
    }

    public Field getDescriptionPropertyField() {
        return this.descriptionPropertyField;
    }

    public void setDescriptionPropertyName(String descriptionPropertyName) {
        this.descriptionPropertyName = descriptionPropertyName;
    }

    private void setDescriptionPropertyField(Field descriptionPropertyField) {
        if (!descriptionPropertyField.getType().equals(String.class)) {
            throw new IllegalArgumentException("Property " + descriptionPropertyField.getName() + " of class " + descriptionPropertyField.getDeclaringClass().getName() + " is annotated with the @ConfigurationItemDescription annotation but is not a String");
        }
        descriptionPropertyField.setAccessible(true);
        this.descriptionPropertyField = descriptionPropertyField;
        this.descriptionPropertyName = descriptionPropertyField.getName();
    }

    public String getDescriptionValueFromConfigurationItem(Object configurationItem) {
        configurationItem = ConfigurationItemReflectionUtils.getRealConfigurationItem(configurationItem);
        return (String)this.getFieldValueOrReturnNull(this.descriptionPropertyField, configurationItem);
    }

    public void setDescriptionValueInConfigurationItem(Object configurationItem, String descriptionValue) {
        configurationItem = ConfigurationItemReflectionUtils.getRealConfigurationItem(configurationItem);
        this.setFieldValue(this.descriptionPropertyField, configurationItem, descriptionValue);
    }

    public String getDefaultDescription() {
        return this.defaultDescription;
    }

    public void setDefaultDescription(String defaultDescription) {
        this.defaultDescription = defaultDescription;
    }

    public String getPermissionSchemePropertyName() {
        return this.permissionSchemePropertyName;
    }

    public Field getPermissionSchemePropertyField() {
        return this.permissionSchemePropertyField;
    }

    public void setPermissionSchemePropertyName(String permissionSchemePropertyName) {
        this.permissionSchemePropertyName = permissionSchemePropertyName;
    }

    private void setPermissionSchemePropertyField(Field permissionSchemePropertyField) {
        if (!permissionSchemePropertyField.getType().equals(PermissionScheme.class)) {
            throw new IllegalArgumentException("Property " + permissionSchemePropertyField.getName() + " of class " + this.descriptionPropertyField.getDeclaringClass().getName() + " is annotated with the @ConfigurationItemPermissionScheme annotation but is not a String");
        }
        permissionSchemePropertyField.setAccessible(true);
        this.permissionSchemePropertyField = permissionSchemePropertyField;
        this.permissionSchemePropertyName = permissionSchemePropertyField.getName();
    }

    public PermissionScheme getPermissionSchemeValueFromConfigurationItem(Object configurationItem) {
        configurationItem = ConfigurationItemReflectionUtils.getRealConfigurationItem(configurationItem);
        return (PermissionScheme)this.getFieldValueOrReturnNull(this.permissionSchemePropertyField, configurationItem);
    }

    public void setPermissionSchemeValueInConfigurationItem(Object configurationItem, PermissionScheme permissionSchemeValue) {
        configurationItem = ConfigurationItemReflectionUtils.getRealConfigurationItem(configurationItem);
        this.setFieldValue(this.permissionSchemePropertyField, configurationItem, permissionSchemeValue);
    }

    public String getDefaultPermissionSchemeLabel() {
        return this.defaultPermissionSchemeLabel;
    }

    public void setDefaultPermissionSchemeLabel(String defaultPermissionSchemeLabel) {
        this.defaultPermissionSchemeLabel = defaultPermissionSchemeLabel;
    }

    private Object getFieldValueOrReturnNull(Field propertyField, Object theObject) {
        if (propertyField != null) {
            propertyField.setAccessible(true);
            try {
                return propertyField.get(theObject);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException("Unable to access field " + propertyField.getName() + " for CI " + theObject.getClass().getName(), e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Unable to access field " + propertyField.getName() + " for CI " + theObject.getClass().getName(), e);
            }
        }
        return null;
    }

    private void setFieldValue(Field propertyField, Object theObject, Object theValue) {
        if (propertyField != null) {
            propertyField.setAccessible(true);
            try {
                propertyField.set(theObject, theValue);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException("Unable to access field " + propertyField.getName() + " for CI " + theObject.getClass().getName(), e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Unable to access field " + propertyField.getName() + " for CI " + theObject.getClass().getName(), e);
            }
        }
    }

    public Set<String> getInterfaces() {
        return this.interfaces;
    }

    public Set<String> getInterfacesWithoutSerializable() {
        HashSet<String> interfacesWithoutSerializable = new HashSet<String>();
        interfacesWithoutSerializable.addAll(this.interfaces);
        interfacesWithoutSerializable.remove(Serializable.class.getName());
        return interfacesWithoutSerializable;
    }

    public void setInterfaces(Set<String> interfaces) {
        this.interfaces = interfaces;
    }

    public List<String> getSuperClasses() {
        return this.superClasses;
    }

    public void setSuperClasses(List<String> superClasses) {
        this.superClasses = superClasses;
    }

    public String getMappingSourceType() {
        return this.mappingSourceType;
    }

    public void setMappingSourceType(String applicableSourceType) {
        this.mappingSourceType = applicableSourceType;
    }

    public String getMappingTargetType() {
        return this.mappingTargetType;
    }

    public void setMappingTargetType(String applicableTargetType) {
        this.mappingTargetType = applicableTargetType;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public ConfigurationItemRoot getRoot() {
        return this.root;
    }

    public void setRoot(ConfigurationItemRoot root) {
        this.root = root;
    }

    public boolean isDiscoverable() {
        return this.discoverable;
    }

    public void setDiscoverable(boolean discoverable) {
        this.discoverable = discoverable;
    }

    public Field getPlaceholderFormatField() {
        return this.placeholderFormatField;
    }

    public String getPlaceholderFormatName() {
        return this.placeholderFormatName;
    }

    public void setPlaceholderFormatName(String placeholderFormatName) {
        this.placeholderFormatName = placeholderFormatName;
    }

    public Field getPlaceholdersField() {
        return this.placeholdersField;
    }

    public String getPlaceholdersName() {
        return this.placeholdersName;
    }

    public void setPlaceholdersName(String placeholdersName) {
        this.placeholdersName = placeholdersName;
    }

    @Override
    public int compareTo(ConfigurationItemDescriptor descriptor) {
        return this.simpleName.compareTo(descriptor.simpleName);
    }

    public String toString() {
        return "ConfigurationItemTypeDescriptor of " + this.getType();
    }
}

