/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.util;

import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.ChangePlan;
import com.xebialabs.deployit.ChangeResolution;
import com.xebialabs.deployit.RunBook;
import com.xebialabs.deployit.Step;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class SingleTypeHandlingRunBook<T extends Serializable>
implements RunBook {
    private final Class<T> ciType;

    public SingleTypeHandlingRunBook(Class<T> ciType) {
        this.ciType = ciType;
    }

    @Override
    public Collection<ChangeResolution> resolve(ChangePlan changePlan) {
        ArrayList<ChangeResolution> crs = new ArrayList<ChangeResolution>();
        for (Change<?> eachChange : changePlan.getChanges()) {
            if (!this.ciType.isAssignableFrom(eachChange.getConfigurationItemClass())) continue;
            ArrayList<Step> steps = new ArrayList<Step>();
            this.resolve(eachChange, changePlan, steps);
            if (steps.isEmpty()) continue;
            ChangeResolution cr = new ChangeResolution(eachChange);
            cr.addSteps(steps);
            crs.add(cr);
        }
        return crs;
    }

    protected abstract void resolve(Change<T> var1, ChangePlan var2, List<Step> var3);
}

