/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.steps;

import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.StepExecutionContextCallbackHandler;
import com.xebialabs.deployit.ci.Database;
import com.xebialabs.deployit.ci.artifact.SqlFolder;
import com.xebialabs.deployit.ci.artifact.mapping.PlaceholderFormat;
import com.xebialabs.deployit.exception.RuntimeIOException;
import com.xebialabs.deployit.hostsession.CommandExecutionCallbackHandler;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.steps.AbstractDatabaseStep;
import com.xebialabs.deployit.util.TemplateResolver;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RunSqlScriptWithUploadedScriptOnDatabaseStep
extends AbstractDatabaseStep
implements Step {
    private final File sqlFile;
    private final String relativeSqlFile;

    public RunSqlScriptWithUploadedScriptOnDatabaseStep(Database target, SqlFolder source, File sqlFile, Map<String, String> properties, PlaceholderFormat placeholderFormat) {
        super(source, target, properties, placeholderFormat);
        this.sqlFile = sqlFile;
        this.relativeSqlFile = this.getRelativePath();
    }

    private String getRelativePath() {
        return this.sqlFile.getAbsolutePath().substring(new File(this.source.getLocation()).getAbsolutePath().length() + 1);
    }

    @Override
    public String getDescription() {
        return "Executing SQL Script " + this.sqlFile + " on " + this.database.getLabel();
    }

    @Override
    public boolean execute(StepExecutionContext ctx) {
        HostSession s = this.getHostSession(ctx);
        try {
            HostFile remoteSqlFile = this.getRemoteLocation(ctx).getFile(this.relativeSqlFile);
            SqlErrorContextCallbackHandler handler = new SqlErrorContextCallbackHandler(ctx);
            int retCode = s.execute((CommandExecutionCallbackHandler)handler, this.getSqlRunnerPath(ctx), remoteSqlFile.getPath());
            if (handler.hasErrors()) {
                throw new RuntimeException("SQL errors has been detected when running " + remoteSqlFile + ":" + handler.getErrors());
            }
            return retCode == 0;
        }
        catch (RuntimeIOException exc) {
            throw new RuntimeIOException("Cannot execute remote command \"" + this.database.getCommand() + "\" on " + this.database.getHost(), exc);
        }
    }

    private String getResolvedOptions() {
        String unresolvedOptions = this.database.getOptions();
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("user", this.database.getUser());
        variables.put("password", this.database.getPassword());
        variables.put("database", this.database.getDatabase());
        TemplateResolver resolver = new TemplateResolver(variables);
        String resolvedOptions = resolver.resolveLenient(unresolvedOptions);
        return resolvedOptions;
    }

    private class SqlErrorContextCallbackHandler
    extends StepExecutionContextCallbackHandler {
        private final List<String> errors;

        public SqlErrorContextCallbackHandler(StepExecutionContext ctx) {
            super(ctx);
            this.errors = new ArrayList<String>();
        }

        @Override
        public void handleOutputLine(String line) {
            super.handleOutputLine(line);
            this.errorHandler(line);
        }

        @Override
        public void handleErrorLine(String line) {
            super.handleErrorLine(line);
            this.errorHandler(line);
        }

        private void errorHandler(String line) {
            if (line.startsWith("ERROR")) {
                this.errors.add(line);
            }
        }

        public boolean hasErrors() {
            return !this.errors.isEmpty();
        }

        public String getErrors() {
            return this.errors.toString();
        }
    }
}

