/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.step;

import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.ci.Host;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostSession;

public class CheckFileExistenceStep
implements Step {
    protected final Host host;
    protected final String filePath;
    protected final boolean mustBeReadable;
    protected final boolean mustBeWritable;
    protected final boolean mustBeExecutable;

    public CheckFileExistenceStep(Host host, String filePath, boolean mustBeReadable, boolean mustBeWritable, boolean mustBeExecutable) {
        this.host = host;
        this.filePath = filePath;
        this.mustBeReadable = mustBeReadable;
        this.mustBeWritable = mustBeWritable;
        this.mustBeExecutable = mustBeExecutable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(StepExecutionContext ctx) {
        HostSession rhs = this.host.getHostSession();
        try {
            HostFile f = rhs.getFile(this.filePath);
            if (!f.exists()) {
                ctx.logError("File " + this.filePath + " does not exist on host " + this.host);
                boolean bl = false;
                return bl;
            }
            ctx.logOutput("File " + this.filePath + " exists on host " + this.host);
            if (f.isDirectory()) {
                ctx.logError("File " + this.filePath + " on host " + this.host + " is a directory");
                boolean bl = false;
                return bl;
            }
            ctx.logOutput("File " + this.filePath + " on host " + this.host + " is a regular file");
            if (this.mustBeReadable) {
                if (!f.canRead()) {
                    ctx.logError("File " + this.filePath + " on host " + this.host + " is not readable");
                    boolean bl = false;
                    return bl;
                }
                ctx.logOutput("File " + this.filePath + " on host " + this.host + " is readable");
            }
            if (this.mustBeWritable) {
                if (!f.canWrite()) {
                    ctx.logError("File " + this.filePath + " on host " + this.host + " is not writable");
                    boolean bl = false;
                    return bl;
                }
                ctx.logOutput("File " + this.filePath + " on host " + this.host + " is writable");
            }
            if (!f.canExecute()) {
                ctx.logError("File " + this.filePath + " on host " + this.host + " is not executable");
                boolean bl = false;
                return bl;
            }
            ctx.logOutput("File " + this.filePath + " on host " + this.host + " is executable");
            ctx.logOutput("Check for existence and permissions of file " + this.filePath + " on host " + this.host + " has succeeded");
            boolean bl = true;
            return bl;
        }
        finally {
            rhs.close();
        }
    }

    @Override
    public String getDescription() {
        return "Check existence and permissions of file " + this.filePath + " on host " + this.host;
    }
}

