/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.ci.artifact.mapping;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.ci.artifact.EjbJar;
import com.xebialabs.deployit.ci.artifact.mapping.DeployableArtifactMapping;
import com.xebialabs.deployit.ci.mapping.MdbListenerPortBinding;
import com.xebialabs.deployit.util.EjbJarFileInfoExtractor;
import java.io.File;
import java.io.Serializable;
import java.util.List;

@ConfigurationItem(description="A mapping of an EjbJar to any kind of middleware")
public abstract class EjbJarMapping<T extends Serializable>
extends DeployableArtifactMapping<EjbJar, T> {
    @ConfigurationItemProperty(description="Bindings of message driven beans JNDI names to the corresponding listener ports present on the target middleware")
    private List<MdbListenerPortBinding> mdbListenerPortJndiNameBindings = Lists.newArrayList();

    public EjbJarMapping() {
    }

    public EjbJarMapping(EjbJar source, T target) {
        super(source, target);
    }

    @Override
    public void postInit(Deployment deployment) {
        if (this.getSource() != null && new File(((EjbJar)this.getSource()).getLocation()).exists()) {
            this.mdbListenerPortJndiNameBindings = EjbJarFileInfoExtractor.getMdbListenerPortBindings((EjbJar)this.getSource());
        }
    }

    public List<MdbListenerPortBinding> getMdbListenerPortBindings() {
        return this.mdbListenerPortJndiNameBindings;
    }

    public void setMdbListenerPortBindings(List<MdbListenerPortBinding> mdbListenerPortBindings) {
        this.mdbListenerPortJndiNameBindings = mdbListenerPortBindings;
    }
}

