/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.util;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.ResolutionException;
import com.xebialabs.deployit.ci.artifact.EjbJar;
import com.xebialabs.deployit.ci.mapping.MdbListenerPortBinding;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class EjbJarFileInfoExtractor {
    public static List<MdbListenerPortBinding> getMdbListenerPortBindings(EjbJar ejbJar) {
        Document doc = EjbJarFileInfoExtractor.parseDescriptorFile(ejbJar);
        ArrayList mdbNames = Lists.newArrayList();
        NodeList nodeList = doc.getElementsByTagName("message-driven");
        for (int i = 0; nodeList != null && i < nodeList.getLength(); ++i) {
            Element refNameElement = (Element)nodeList.item(0);
            String mdbName = EjbJarFileInfoExtractor.findName(refNameElement, "ejb-name");
            mdbNames.add(new MdbListenerPortBinding(EjbJarFileInfoExtractor.getEjbModuleName(doc), mdbName, ""));
        }
        return mdbNames;
    }

    private static String getEjbModuleName(Document doc) {
        NodeList nodeList = doc.getElementsByTagName("display-name");
        int i = 0;
        if (nodeList != null && i < nodeList.getLength()) {
            Node refNameElement = nodeList.item(0);
            return refNameElement.getFirstChild().getNodeValue();
        }
        return null;
    }

    private static Document parseDescriptorFile(EjbJar ejbJarFile) {
        InputStream is = null;
        try {
            JarFile jarFile = new JarFile(new File(ejbJarFile.getLocation()));
            JarEntry jarEntry = jarFile.getJarEntry("META-INF/ejb-jar.xml");
            if (jarEntry != null) {
                is = jarFile.getInputStream(jarEntry);
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                DocumentBuilder db = dbf.newDocumentBuilder();
                EjbJarFileInfoExtractor.disableDtdValidation(db);
                Document document = db.parse(is);
                return document;
            }
        }
        catch (Exception e) {
            throw new ResolutionException("Problems occurred while trying to parse ejb descriptor file for ejb named " + ejbJarFile.getName(), e);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private static void disableDtdValidation(DocumentBuilder db) {
        db.setEntityResolver(new EntityResolver(){

            @Override
            public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                System.out.println("Ignoring " + publicId + ", " + systemId);
                return new InputSource(new StringReader(""));
            }
        });
    }

    private static String findName(Element element, String tagnameOfChild) {
        NodeList refNameElements = element.getElementsByTagName(tagnameOfChild);
        if (refNameElements.getLength() == 1) {
            Node refNameElement = refNameElements.item(0);
            return refNameElement.getFirstChild().getNodeValue();
        }
        return null;
    }
}

