/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.mapper;

import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.ci.mapping.Mapping;
import com.xebialabs.deployit.mapper.Mapper;
import com.xebialabs.deployit.mapper.Pair;
import java.io.Serializable;
import java.util.List;

public abstract class StepGeneratingMapper<S extends Serializable, M extends Mapping<? super S, ? super T>, T extends Serializable>
extends Mapper<S, M, T> {
    public StepGeneratingMapper(Change<Deployment> change, boolean applyDefaultMappings) {
        super(change, applyDefaultMappings);
    }

    public StepGeneratingMapper(Change<Deployment> change) {
        super(change);
    }

    public final void generateAdditionSteps(List<Step> steps) {
        for (Serializable m : this.addedMappings) {
            this.generateAdditionStepsForAddedMapping(((Mapping)m).getSource(), m, ((Mapping)m).getTarget(), steps);
        }
        for (Serializable m : this.modifiedMappings) {
            Mapping newM = (Mapping)((Pair)m).getSecond();
            this.generateAdditionStepsForModifiedMapping(newM.getSource(), newM, newM.getTarget(), steps);
        }
    }

    public final void generateDeletionSteps(List<Step> steps) {
        for (Serializable m : this.modifiedMappings) {
            Mapping oldM = (Mapping)((Pair)m).getFirst();
            this.generateDeletionStepsForModifiedMapping(oldM.getSource(), oldM, oldM.getTarget(), steps);
        }
        for (Serializable m : this.deletedMappings) {
            this.generateDeletionStepsForDeletedMapping(((Mapping)m).getSource(), m, ((Mapping)m).getTarget(), steps);
        }
    }

    protected abstract void generateAdditionStepsForAddedMapping(S var1, M var2, T var3, List<Step> var4);

    protected void generateAdditionStepsForModifiedMapping(S newMappingSource, M newVersionOfModifiedMapping, T newMappingTarget, List<Step> steps) {
        this.generateAdditionStepsForAddedMapping(newMappingSource, newVersionOfModifiedMapping, newMappingTarget, steps);
    }

    protected void generateDeletionStepsForModifiedMapping(S oldMappingSource, M oldVersionOfModifiedMapping, T oldMappingTarget, List<Step> steps) {
        this.generateDeletionStepsForDeletedMapping(oldMappingSource, oldVersionOfModifiedMapping, oldMappingTarget, steps);
    }

    protected abstract void generateDeletionStepsForDeletedMapping(S var1, M var2, T var3, List<Step> var4);
}

