/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.ci.artifact.mapping;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.ci.artifact.War;
import com.xebialabs.deployit.ci.artifact.mapping.DeployableArtifactMapping;
import com.xebialabs.deployit.ci.mapping.EjbReference;
import com.xebialabs.deployit.ci.mapping.ResourceReference;
import com.xebialabs.deployit.util.WarFileInfoExtractor;
import java.io.Serializable;
import java.util.List;

public abstract class WarMapping<T extends Serializable>
extends DeployableArtifactMapping<War, T> {
    @ConfigurationItemProperty(description="Virtual host to deploy to", required=false)
    private String virtualHost;
    @ConfigurationItemProperty(description="Context root to deploy to", required=false)
    private String contextRoot;
    @ConfigurationItemProperty(description="Specifies the mapping from resource references jndi names and types used in the web.xml to resource references jndi names available in middleware", required=false, category="Jndi references")
    private List<ResourceReference> resourceReferences = Lists.newArrayList();
    @ConfigurationItemProperty(description="Specifies the mapping from resource environment references jndi names and types used in the web.xml to resource references jndi names available in middleware", required=false, category="Jndi references")
    private List<ResourceReference> resourceEnvironmentEntryReferences = Lists.newArrayList();
    @ConfigurationItemProperty(description="Specifies the mapping from ejb reference jndi names and locals used in the web.xml to bean jndi names available in middleware", required=false, category="Jndi references")
    private List<EjbReference> ejbReferences = Lists.newArrayList();

    public WarMapping() {
    }

    public WarMapping(War source, T target, String virtualHost, String contextRoot) {
        super(source, target);
        this.virtualHost = virtualHost;
        this.contextRoot = contextRoot;
    }

    @Override
    public void postInit(Deployment deployment) {
        this.setVirtualHost(deployment.getVhostDefinition());
        this.setContextRoot(((War)this.getSource()).getName());
        this.resourceReferences = WarFileInfoExtractor.getResourceReferences((War)this.getSource());
        this.resourceEnvironmentEntryReferences = WarFileInfoExtractor.getResourceEnvironmentEntryReferences((War)this.getSource());
        this.ejbReferences = WarFileInfoExtractor.getEjbReferences((War)this.getSource());
    }

    public String getVirtualHost() {
        return this.virtualHost;
    }

    public void setVirtualHost(String virtualHost) {
        this.virtualHost = virtualHost;
    }

    public String getContextRoot() {
        return this.contextRoot;
    }

    public void setContextRoot(String contextRoot) {
        this.contextRoot = contextRoot;
    }

    public List<ResourceReference> getResourceEnvironmentEntryReferences() {
        return this.resourceEnvironmentEntryReferences;
    }

    public List<ResourceReference> getResourceReferences() {
        return this.resourceReferences;
    }

    public List<EjbReference> getEjbReferences() {
        return this.ejbReferences;
    }

    public void setResourceReferences(List<ResourceReference> resourceReferences) {
        this.resourceReferences = resourceReferences;
    }

    public void setResourceEnvironmentEntryReferences(List<ResourceReference> resourceEnvironmentEntryReferences) {
        this.resourceEnvironmentEntryReferences = resourceEnvironmentEntryReferences;
    }

    public void setEjbReferences(List<EjbReference> ejbReferences) {
        this.ejbReferences = ejbReferences;
    }
}

