/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.ci.artifact;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.ci.artifact.Folder;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

@ConfigurationItem(description="Folder in the Application Package containing sql files. Might contain sub folders")
public class SqlFolder
extends Folder {
    @ConfigurationItemProperty(required=false, description="Default is .sql")
    private String filter = ".sql";
    @ConfigurationItemProperty(description="Placeholders found after scanning the artifact")
    private Set<String> placeholders = Sets.newHashSet();
    private final transient FilenameFilter sqlFilenameFilter = new FilenameFilter(){

        @Override
        public boolean accept(File file, String name) {
            return name.toLowerCase().endsWith(SqlFolder.this.filter);
        }
    };
    private final transient FilenameFilter directoryOnly = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return new File(dir, name).isDirectory();
        }
    };

    public Set<String> getPlaceholders() {
        return this.placeholders;
    }

    public void setPlaceholders(Set<String> placeholders) {
        this.placeholders = placeholders;
    }

    @Override
    public List<File> getFiles() {
        List<File> allfiles = this.getSqlFiles(new File(this.getLocation()));
        Collections.sort(allfiles);
        return allfiles;
    }

    private List<File> getSqlFiles(File folder) {
        ArrayList allfiles = Lists.newArrayList((Object[])folder.listFiles(this.sqlFilenameFilter));
        for (File file : folder.listFiles(this.directoryOnly)) {
            allfiles.addAll(this.getSqlFiles(file));
        }
        return allfiles;
    }
}

