/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.ci;

import com.google.common.base.Preconditions;
import com.xebialabs.deployit.exception.RuntimeIOException;
import com.xebialabs.deployit.hostsession.CmdLine;
import com.xebialabs.deployit.hostsession.CmdLineArgument;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public enum OperatingSystemFamily {
    WINDOWS,
    UNIX;

    private static final String SPECIAL_CHARS = " '\"\\;()${}";

    public String getScriptExtension() {
        if (this == WINDOWS) {
            return ".bat";
        }
        return ".sh";
    }

    public String getLineSeparator() {
        if (this == WINDOWS) {
            return "\r\n";
        }
        return "\n";
    }

    public String getDefaultTemporaryDirectoryPath() {
        if (this == WINDOWS) {
            return "C:\\windows\\temp";
        }
        return "/tmp";
    }

    public String getFileSeparator() {
        if (this == WINDOWS) {
            return "\\";
        }
        return "/";
    }

    public String getPathSeparator() {
        if (this == WINDOWS) {
            return ";";
        }
        return ":";
    }

    public String convertText(String text) {
        if (text == null) {
            return null;
        }
        String lineSep = this.getLineSeparator();
        try {
            String line;
            StringBuilder converted = new StringBuilder();
            BufferedReader r = new BufferedReader(new StringReader(text));
            while ((line = r.readLine()) != null) {
                converted.append(line).append(lineSep);
            }
            return converted.toString();
        }
        catch (IOException exc) {
            throw new RuntimeIOException("Unable to read String", exc);
        }
    }

    public String encodeCommandLineForExecution(CmdLine cmdarray) {
        return this.encodeCommandLine(false, cmdarray);
    }

    public String encodeCommandLineForLogging(CmdLine cmdarray) {
        return this.encodeCommandLine(true, cmdarray);
    }

    private String encodeCommandLine(boolean hidePassword, CmdLine cmdarray) {
        Preconditions.checkNotNull((Object)cmdarray, (Object)"Cannot encode a null command line");
        Preconditions.checkArgument((cmdarray.getArguments().size() > 0 ? 1 : 0) != 0, (Object)"Cannot encode an empty command line");
        StringBuilder sb = new StringBuilder();
        List<CmdLineArgument> arguments = cmdarray.getArguments();
        for (int i = 0; i < arguments.size(); ++i) {
            CmdLineArgument arg;
            if (i != 0) {
                sb.append(" ");
            }
            if ((arg = arguments.get(i)).getArg() == null) {
                throw new NullPointerException("Cannot encode a command line with a null parameter (#" + (i + 1) + ")");
            }
            this.encodeArgument(arg.toString(hidePassword), sb);
        }
        return sb.toString();
    }

    private void encodeArgument(String argument, StringBuilder collector) {
        if (argument.length() == 0) {
            this.encodeEmptyArgument(collector);
        } else if (!StringUtils.containsAny((String)argument, (String)SPECIAL_CHARS)) {
            this.encodeRegularArgument(argument, collector);
        } else if (this == WINDOWS) {
            this.encodeArgumentWithSpecialCharactersForWindows(argument, collector);
        } else {
            this.encodeArgumentWithSpecialCharactersForNonWindows(argument, collector);
        }
    }

    private void encodeEmptyArgument(StringBuilder collector) {
        collector.append("\"\"");
    }

    private void encodeRegularArgument(String argument, StringBuilder collector) {
        collector.append(argument);
    }

    private void encodeArgumentWithSpecialCharactersForWindows(String argument, StringBuilder collector) {
        collector.append("\"");
        for (int j = 0; j < argument.length(); ++j) {
            char c = argument.charAt(j);
            if (c == '\"') {
                collector.append(c);
            }
            collector.append(c);
        }
        collector.append("\"");
    }

    private void encodeArgumentWithSpecialCharactersForNonWindows(String argument, StringBuilder collector) {
        for (int j = 0; j < argument.length(); ++j) {
            char c = argument.charAt(j);
            if (SPECIAL_CHARS.indexOf(c) != -1) {
                collector.append('\\');
            }
            collector.append(c);
        }
    }
}

