package com.xebialabs.deployit.hostsession;

import com.google.common.base.Function;
import com.google.common.collect.Lists;

import java.util.Collections;
import java.util.List;

import static com.google.common.collect.Lists.newArrayList;
import static com.xebialabs.deployit.hostsession.CmdLineArgument.arg;
import static com.xebialabs.deployit.hostsession.CmdLineArgument.password;
import static java.util.Collections.unmodifiableList;
import static org.apache.commons.lang.StringUtils.endsWithIgnoreCase;

public class CmdLine {

    List<CmdLineArgument> arguments = newArrayList();

    public CmdLine addArgument(String arg) {
        arguments.add(arg(arg));
        return this;
    }

    public CmdLine addPassword(String arg) {
        arguments.add(password(arg));
        return this;
    }

    public CmdLine add(CmdLineArgument arg) {
        arguments.add(arg);
        return this;
    }

    public List<CmdLineArgument> getArguments() {
        return unmodifiableList(arguments);
    }

    public String[] toCommandLine(final boolean forLogging) {
        return Lists.transform(arguments, new Function<CmdLineArgument, String>() {
            @Override
            public String apply(CmdLineArgument from) {
                return from.toString(forLogging);
            }
        }).toArray(new String[arguments.size()]);
    }

    public static CmdLine asCommandLine(String... cmdarray) {
        CmdLine cmdLine = new CmdLine();
        boolean seenPassword = false;
        for (String s : cmdarray) {
            if (seenPassword) {
                cmdLine.addPassword(s);
            } else {
                cmdLine.addArgument(s);
            }
            seenPassword = endsWithIgnoreCase(s, "password");
        }
        return cmdLine;
    }

}
