/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.hostsession.ssh;

import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.xebialabs.deployit.exception.RuntimeIOException;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.ssh.SshHostSession;
import com.xebialabs.deployit.hostsession.ssh.SshStreamUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SshScpProtocolHelper {
    private String command;
    private Session session;
    private ChannelExec channel;
    private InputStream channelIn;
    private OutputStream channelOut;
    private static final String CHANNEL_PURPOSE = " (for SCP stream)";
    private SshHostSession sshHostSession;
    private String remotePath;
    private Logger logger = LoggerFactory.getLogger(SshScpProtocolHelper.class);

    public SshScpProtocolHelper(SshHostSession sshHostSession, String remotePath) {
        this.sshHostSession = sshHostSession;
        this.remotePath = remotePath;
    }

    public void open(String scpOptions) {
        try {
            this.session = this.sshHostSession.openSession(CHANNEL_PURPOSE);
            this.channel = (ChannelExec)this.session.openChannel("exec");
            this.command = this.sshHostSession.encodeCommandLineForExecution("scp", "-" + scpOptions, this.remotePath);
            this.channel.setCommand(this.command);
            this.channelIn = this.channel.getInputStream();
            this.channelOut = this.channel.getOutputStream();
            this.channel.connect();
            this.logger.info("Executing remote command \"" + this.command + "\" on " + this + " to open SCP stream");
            this.logger.info("Opened SCP stream to remote file " + this.remotePath);
        }
        catch (IOException exc) {
            throw new RuntimeIOException("Cannot open SCP stream to remote file " + this.remotePath, exc);
        }
        catch (JSchException exc) {
            throw new RuntimeIOException("Cannot open SCP stream to remote file " + this.remotePath, exc);
        }
    }

    public void readAck() {
        this.readAck(0);
    }

    public void readAck(int expectedChar) {
        int c;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Reading ACK");
        }
        if ((c = SshStreamUtils.checkAck(this.channelIn)) != expectedChar) {
            throw new RuntimeIOException("Protocol error on SCP stream to read remote file " + this.remotePath + " (remote scp command returned acked with a \"" + c + "\")");
        }
    }

    public void sendFilePreamble(HostFile file, long length) throws IOException {
        String preamble = "C0644 " + length + " " + this.getFileName(file);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Sending file preamble \"" + preamble + "\"");
        }
        preamble = preamble + "\n";
        this.channelOut.write(preamble.getBytes());
        this.channelOut.flush();
    }

    private String getFileName(HostFile file) {
        if (file.getPath().lastIndexOf(47) > 0) {
            return file.getPath().substring(file.getPath().lastIndexOf(47) + 1);
        }
        return file.getPath();
    }

    public void sendDirectoryPostscript(HostFile dir) throws IOException {
        String postscript = "E\n";
        this.channelOut.write(postscript.getBytes());
        this.channelOut.flush();
    }

    public void sendDirectoryPreamble(HostFile dir) throws IOException {
        String preamble = "D0755 0 " + this.getFileName(dir);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Sending dir preamble \"" + preamble + "\"");
        }
        preamble = preamble + "\n";
        this.channelOut.write(preamble.getBytes());
        this.channelOut.flush();
    }

    public void sendAck() throws IOException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Sending ACK");
        }
        this.channelOut.write(0);
        this.channelOut.flush();
    }

    public void write(InputStream is) throws IOException {
        IOUtils.copy((InputStream)is, (OutputStream)this.channelOut);
    }

    public void write(byte[] b) throws IOException {
        this.channelOut.write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.channelOut.write(b, off, len);
    }

    public void write(int b) throws IOException {
        this.channelOut.write(b);
    }

    public int close() {
        int res = 0;
        if (this.channel != null) {
            IOUtils.closeQuietly((OutputStream)this.channelOut);
            res = SshHostSession.waitForExitStatus(this.channel, this.command);
            IOUtils.closeQuietly((InputStream)this.channelIn);
            this.channel.disconnect();
        }
        this.sshHostSession.disconnectSession(this.session, CHANNEL_PURPOSE);
        return res;
    }

    public InputStream getChannelIn() {
        return this.channelIn;
    }
}

