/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.hostsession.common;

import com.xebialabs.deployit.exception.RuntimeIOException;
import com.xebialabs.deployit.hostsession.HostFile;
import java.io.IOException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HostFileDirectoryWalker {
    public static final int ROOT = 0;
    private final int depthLimit;

    protected HostFileDirectoryWalker() {
        this(-1);
    }

    protected HostFileDirectoryWalker(int depthLimit) {
        this.depthLimit = depthLimit;
    }

    protected final void walk(HostFile startDirectory) throws RuntimeIOException {
        try {
            if (startDirectory == null) {
                throw new NullPointerException("Start Directory is null");
            }
            this.handleStart(startDirectory);
            this.walk(startDirectory, 0);
            this.handleEnd();
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    private void walk(HostFile directory, int depth) throws IOException {
        if (this.handleDirectory(directory, depth)) {
            this.handleDirectoryStart(directory, depth);
            int childDepth = depth + 1;
            if (this.depthLimit < 0 || childDepth <= this.depthLimit) {
                List<HostFile> childFiles = this.listFiles(directory);
                if (childFiles == null) {
                    this.handleRestricted(directory, childDepth);
                } else {
                    for (HostFile childFile : childFiles) {
                        if (childFile.isDirectory()) {
                            this.walk(childFile, childDepth);
                            continue;
                        }
                        this.handleFile(childFile, childDepth);
                    }
                }
            }
            this.handleDirectoryEnd(directory, depth);
        }
    }

    protected List<HostFile> listFiles(HostFile directory) {
        return directory.listFiles();
    }

    protected void handleStart(HostFile startDirectory) throws IOException {
    }

    protected boolean handleDirectory(HostFile directory, int depth) throws IOException {
        return true;
    }

    protected void handleDirectoryStart(HostFile directory, int depth) throws IOException {
    }

    protected void handleFile(HostFile file, int depth) throws IOException {
    }

    protected void handleRestricted(HostFile directory, int depth) throws IOException {
    }

    protected void handleDirectoryEnd(HostFile directory, int depth) throws IOException {
    }

    protected void handleEnd() throws IOException {
    }
}

