/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.hostsession.ssh;

import com.xebialabs.deployit.exception.RuntimeIOException;
import com.xebialabs.deployit.hostsession.CapturingCommandExecutionCallbackHandler;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostFileInputStreamTransformer;
import com.xebialabs.deployit.hostsession.ssh.SshHostFile;
import com.xebialabs.deployit.hostsession.ssh.SshHostSession;
import com.xebialabs.deployit.hostsession.ssh.SshScpDirectoryCopier;
import com.xebialabs.deployit.hostsession.ssh.SshScpInputStream;
import com.xebialabs.deployit.hostsession.ssh.SshScpOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SshScpHostFile
extends SshHostFile {
    private Logger logger = LoggerFactory.getLogger(SshScpHostFile.class);

    public SshScpHostFile(SshHostSession session, String remotePath) {
        super(session, remotePath);
    }

    @Override
    public boolean exists() throws RuntimeIOException {
        return this.executeStat().exists;
    }

    @Override
    public boolean isDirectory() throws RuntimeIOException {
        return this.executeStat().isDirectory;
    }

    @Override
    public long length() throws RuntimeIOException {
        return this.executeStat().length;
    }

    @Override
    public boolean canRead() throws RuntimeIOException {
        return this.executeStat().canRead;
    }

    @Override
    public boolean canWrite() throws RuntimeIOException {
        return this.executeStat().canWrite;
    }

    @Override
    public boolean canExecute() throws RuntimeIOException {
        return this.executeStat().canExecute;
    }

    @Override
    public List<String> list() throws RuntimeIOException {
        CapturingCommandExecutionCallbackHandler capturedOutput = new CapturingCommandExecutionCallbackHandler();
        int errno = this.executeCommand(capturedOutput, "ls", "-1", this.remotePath);
        if (errno != 0) {
            throw new RuntimeIOException("Cannot list directory " + this + ": " + capturedOutput.getError() + " (errno=" + errno + ")");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Listed directory " + this);
        }
        return capturedOutput.getOutputLines();
    }

    @Override
    public void mkdir() throws RuntimeIOException {
        this.mkdir(new String[0]);
    }

    @Override
    public void mkdirs() throws RuntimeIOException {
        this.mkdir(new String[]{"-p"});
    }

    protected void mkdir(String[] args) throws RuntimeIOException {
        CapturingCommandExecutionCallbackHandler capturedOutput = new CapturingCommandExecutionCallbackHandler();
        int errno = this.executeCommand(capturedOutput, this.makeMkdirCommand(args));
        if (errno != 0) {
            throw new RuntimeIOException("Cannot create directory or -ies " + this + ": " + capturedOutput.getError() + " (errno=" + errno + ")");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Created directory " + this);
        }
    }

    private String[] makeMkdirCommand(String[] args) {
        int numArgs = args.length;
        String[] command = new String[numArgs + 2];
        command[0] = "mkdir";
        System.arraycopy(args, 0, command, 1, numArgs);
        command[numArgs + 1] = this.remotePath;
        return command;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void moveTo(HostFile destFile) {
        if (!(destFile instanceof SshScpHostFile)) throw new RuntimeIOException("Cannot move/rename SSH/SCP file/directory " + this + " to non-SSH/SCP file/directory " + destFile);
        SshScpHostFile sshScpDestFile = (SshScpHostFile)destFile;
        if (sshScpDestFile.getSession() != this.getSession()) throw new RuntimeIOException("Cannot move/rename SSH/SCP file/directory " + this + " to SSH/SCP file/directory " + destFile + " because it is in a different session");
        CapturingCommandExecutionCallbackHandler capturedOutput = new CapturingCommandExecutionCallbackHandler();
        int errno = this.executeCommand(capturedOutput, "mv", this.remotePath, sshScpDestFile.getPath());
        if (errno == 0) return;
        throw new RuntimeIOException("Cannot move/rename file/directory " + this + ": " + capturedOutput.getError() + " (errno=" + errno + ")");
    }

    @Override
    protected void deleteDirectory() {
        CapturingCommandExecutionCallbackHandler capturedOutput = new CapturingCommandExecutionCallbackHandler();
        int errno = this.executeCommand(capturedOutput, "rmdir", this.remotePath);
        if (errno != 0) {
            throw new RuntimeIOException("Cannot delete directory " + this + ": " + capturedOutput.getError() + " (errno=" + errno + ")");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Deleted directory " + this);
        }
    }

    @Override
    protected void deleteFile() {
        CapturingCommandExecutionCallbackHandler capturedOutput = new CapturingCommandExecutionCallbackHandler();
        int errno = this.executeCommand(capturedOutput, "rm", "-f", this.remotePath);
        if (errno != 0) {
            throw new RuntimeIOException("Cannot delete file " + this + ": " + capturedOutput.getError() + " (errno=" + errno + ")");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Deleted file " + this);
        }
    }

    @Override
    public boolean deleteRecursively() throws RuntimeIOException {
        if (!this.exists()) {
            return false;
        }
        CapturingCommandExecutionCallbackHandler capturedOutput = new CapturingCommandExecutionCallbackHandler();
        int errno = this.executeCommand(capturedOutput, "rm", "-rf", this.remotePath);
        if (errno != 0) {
            throw new RuntimeIOException("Cannot recursively delete directory " + this + ": " + capturedOutput.getError() + " (errno=" + errno + ")");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Recursively deleted file/directory " + this);
        }
        return true;
    }

    @Override
    public InputStream get() throws RuntimeIOException {
        SshScpInputStream in = new SshScpInputStream(this);
        in.open();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Opened SCP input stream from file " + this);
        }
        return in;
    }

    @Override
    public OutputStream put(long length) throws RuntimeIOException {
        SshScpOutputStream out = new SshScpOutputStream(this, length);
        out.open();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Opened SCP output stream to file " + this);
        }
        return out;
    }

    @Override
    public void copyFrom(HostFile srcHostFile, HostFileInputStreamTransformer transformer) throws RuntimeIOException {
        if (srcHostFile.isDirectory()) {
            SshScpDirectoryCopier dirCopier = new SshScpDirectoryCopier(srcHostFile, this, transformer);
            dirCopier.startCopy();
        } else {
            super.copyFrom(srcHostFile, transformer);
        }
    }
}

