/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.util;

import com.xebialabs.deployit.ResolutionException;
import com.xebialabs.deployit.ci.artifact.mapping.PlaceholderFormat;
import com.xebialabs.deployit.mapper.Pair;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateResolver {
    public static final String PROPERTY_SEPERATOR = ".";
    private Map<String, String> variables = new HashMap<String, String>();
    private PlaceholderFormat placeholderFormat;

    public TemplateResolver(Collection<Object> context) {
        this(TemplateResolver.contextToVariables(context), PlaceholderFormat.SPRING);
    }

    public TemplateResolver(Map<String, String> variables) {
        this(variables, PlaceholderFormat.SPRING);
    }

    public TemplateResolver(Collection<Object> context, PlaceholderFormat placeholderFormat) {
        this(TemplateResolver.contextToVariables(context), placeholderFormat);
    }

    public TemplateResolver(Map<String, String> variables, PlaceholderFormat placeholderFormat) {
        this.placeholderFormat = placeholderFormat;
        for (Map.Entry<String, String> each : variables.entrySet()) {
            if (each.getKey() == null) continue;
            String key = each.getKey();
            if (placeholderFormat.equals(PlaceholderFormat.NONE)) {
                this.variables.put(key, each.getValue());
            }
            this.variables.put(key.toLowerCase(), each.getValue());
        }
    }

    public String resolveLenient(String template) {
        if (this.placeholderFormat.equals(PlaceholderFormat.NONE)) {
            return this.resolveWithNone(template);
        }
        return this.resolveInternal(template, false);
    }

    public String resolveStrict(String template) {
        if (this.placeholderFormat.equals(PlaceholderFormat.NONE)) {
            return this.resolveWithNone(template);
        }
        return this.resolveInternal(template, true);
    }

    private String resolveWithNone(String template) {
        String resolved = template;
        for (Map.Entry<String, String> each : this.variables.entrySet()) {
            resolved = StringUtils.replace((String)resolved, (String)each.getKey(), (String)each.getValue());
        }
        return resolved;
    }

    private String resolveInternal(String template, boolean strict) {
        if (template == null) {
            return null;
        }
        StringBuilder value = new StringBuilder();
        String t = template;
        while (t.length() > 0) {
            int endIndex;
            int startIndex = t.indexOf(this.placeholderFormat.getPrefix());
            if (startIndex != -1 && (endIndex = t.indexOf(this.placeholderFormat.getPostfix(), startIndex + 1)) != -1) {
                String afterPlaceholder;
                String propertyToLookFor = t.substring(startIndex + this.placeholderFormat.getPrefix().length(), endIndex);
                String propertyValue = this.variables.get(propertyToLookFor.toLowerCase());
                if (strict && StringUtils.isBlank((String)propertyValue)) {
                    throw new ResolutionException("Cannot resolve template \"" + template + "\"  because template variable " + propertyToLookFor + " has no value");
                }
                if (StringUtils.isBlank((String)propertyValue) && !this.variables.containsKey(propertyToLookFor)) {
                    String beforeAndIncludingPlaceholder = t.substring(0, endIndex + 1);
                    afterPlaceholder = t.substring(endIndex + 1);
                    value.append(beforeAndIncludingPlaceholder);
                    t = afterPlaceholder;
                    continue;
                }
                String beforePlaceholder = t.substring(0, startIndex);
                afterPlaceholder = t.substring(endIndex + 1);
                value.append(beforePlaceholder);
                value.append(propertyValue);
                t = afterPlaceholder;
                continue;
            }
            value.append(t);
            t = "";
        }
        return value.toString();
    }

    public static Map<String, String> contextToVariables(Collection<? extends Object> context) {
        HashMap<String, String> properties = new HashMap<String, String>();
        for (Object object : context) {
            if (object == null) continue;
            List<String> readableFields = TemplateResolver.getExposedProperties(object);
            for (String fieldName : readableFields) {
                Object fieldValue;
                Pair<List<String>, Object> res = TemplateResolver.getValueWithSimpleName(object, fieldName);
                if (res == null || (fieldValue = res.getSecond()) == null) continue;
                List<String> classnames = res.getFirst();
                for (String classname : classnames) {
                    properties.put(classname.toLowerCase() + PROPERTY_SEPERATOR + fieldName.toLowerCase(), fieldValue.toString());
                }
            }
        }
        return properties;
    }

    private static BeanInfo getBeanInfo(Object detailsObject) {
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(detailsObject.getClass());
        }
        catch (IntrospectionException e) {
            throw new RuntimeException("Unable to introspect object " + detailsObject, e);
        }
        return beanInfo;
    }

    public static List<String> getExposedProperties(Object detailsObject) {
        return TemplateResolver.getExposedProperties(TemplateResolver.getBeanInfo(detailsObject));
    }

    private static List<String> getExposedProperties(BeanInfo beanInfo) {
        ArrayList<String> properties = new ArrayList<String>();
        PropertyDescriptor[] javaBeanDescriptor = beanInfo.getPropertyDescriptors();
        for (int i = 0; i < javaBeanDescriptor.length; ++i) {
            PropertyDescriptor beanDescriptor = javaBeanDescriptor[i];
            boolean isWriteAble = beanDescriptor.getWriteMethod() != null;
            String property = beanDescriptor.getName();
            if (!isWriteAble || property.equals("id") || property.equals("class") || property.equals("groupRevision") || property.equals("handle") || property.equals("revision") || property.equals("typeDescriptor") || property.equals("type")) continue;
            properties.add(beanDescriptor.getName().toLowerCase());
        }
        properties.add("label");
        properties.add("description");
        return properties;
    }

    public static Pair<List<String>, Object> getValueWithSimpleName(Object anObject, String fieldName) {
        BeanInfo beanInfo = TemplateResolver.getBeanInfo(anObject);
        for (PropertyDescriptor descriptor : beanInfo.getPropertyDescriptors()) {
            String name = descriptor.getName();
            if (!name.equalsIgnoreCase(fieldName)) continue;
            Method readMethod = descriptor.getReadMethod();
            try {
                if (readMethod == null) continue;
                Class<?> currentClazz = anObject.getClass();
                Class<?> clazz = readMethod.getDeclaringClass();
                Object value = readMethod.invoke(anObject, (Object[])null);
                List<String> classNames = TemplateResolver.makeClassNames(currentClazz, clazz);
                return new Pair<List<String>, Object>(classNames, value);
            }
            catch (Throwable exc) {
                throw new RuntimeException("Could not get value for " + anObject.getClass() + PROPERTY_SEPERATOR + fieldName, exc);
            }
        }
        return null;
    }

    private static List<String> makeClassNames(Class<?> currentClazz, Class<?> clazz) {
        ArrayList<String> classNames = new ArrayList<String>();
        while (currentClazz != clazz) {
            classNames.add(currentClazz.getSimpleName());
            currentClazz = currentClazz.getSuperclass();
        }
        classNames.add(currentClazz.getSimpleName());
        return classNames;
    }
}

