/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.step;

import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.ci.Host;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostSession;

public class CheckDirExistsStep
implements Step {
    protected final Host host;
    protected final String directory;

    public CheckDirExistsStep(Host host, String directory) {
        this.host = host;
        this.directory = directory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(StepExecutionContext ctx) {
        boolean dirExists = false;
        HostSession rhs = this.host.getHostSession();
        try {
            HostFile dir = rhs.getFile(this.directory);
            boolean bl = dirExists = dir.exists() && dir.isDirectory();
            if (dirExists) {
                ctx.logOutput("Directory " + this.directory + " exists on host " + this.host);
            } else {
                ctx.logOutput("Directory " + this.directory + " on host " + this.host + " does not exist");
            }
        }
        finally {
            rhs.close();
        }
        return dirExists;
    }

    public String getDescription() {
        return "Check existence of directory " + this.directory + " on host " + this.host + "...";
    }
}

