/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.hostsession;

import com.xebialabs.deployit.exception.RuntimeIOException;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostFileInputStreamTransformer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.tools.tar.TarEntry;
import org.apache.tools.tar.TarInputStream;

public class HostFileUtils {
    private static final String ZIP_PATH_SEPARATOR = "/";
    private static final String TAR_PATH_SEPARATOR = "/";
    private static final byte[] UTF16LE_PREAMABLE = new byte[]{-1, -2};
    private static final byte[] UTF16BE_PREAMABLE = new byte[]{-2, -1};
    private static Logger logger = Logger.getLogger(HostFileUtils.class);

    public static void copy(HostFile src, HostFile dst) {
        HostFileUtils.copy(src, dst, null);
    }

    public static void copy(HostFile src, HostFile dst, HostFileInputStreamTransformer transformer) {
        if (src.isDirectory()) {
            HostFileUtils.copyDirectory(src, dst, transformer);
        } else {
            HostFileUtils.copyFile(src, dst, transformer);
        }
    }

    public static void copyFile(HostFile srcFile, HostFile dstFile) throws RuntimeIOException {
        HostFileUtils.copyFile(srcFile, dstFile, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(HostFile srcFile, HostFile dstFile, HostFileInputStreamTransformer transformer) throws RuntimeIOException {
        InputStream transformedInputStream;
        if (!srcFile.exists()) {
            throw new RuntimeIOException("Source file " + srcFile + " does not exist");
        }
        if (srcFile.isDirectory()) {
            throw new RuntimeIOException("Source file " + srcFile + " exists but is a directory");
        }
        if (dstFile.exists()) {
            if (dstFile.isDirectory()) {
                throw new RuntimeIOException("Destination file " + dstFile + " exists but is a directory");
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("About to overwrite existing file " + dstFile));
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Copying contents of regular file " + srcFile + " to " + dstFile));
        }
        InputStream in = null;
        long length = -1L;
        if (transformer != null && (transformedInputStream = transformer.transform(srcFile)) != null) {
            try {
                ByteArrayOutputStream bytes = HostFileUtils.readIntoByteArrayOutputStream(srcFile, transformedInputStream);
                length = bytes.size();
                in = new ByteArrayInputStream(bytes.toByteArray());
            }
            finally {
                IOUtils.closeQuietly((InputStream)transformedInputStream);
            }
        }
        if (in == null) {
            in = srcFile.get();
            length = srcFile.length();
        }
        try {
            dstFile.put(in, length);
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    public static void copyDirectory(HostFile srcDir, HostFile dstDir) throws RuntimeIOException {
        HostFileUtils.copyDirectory(srcDir, dstDir, null);
    }

    public static void copyDirectory(HostFile srcDir, HostFile dstDir, HostFileInputStreamTransformer transformer) throws RuntimeIOException {
        if (!srcDir.exists()) {
            throw new RuntimeIOException("Source directory " + srcDir + " does not exist");
        }
        if (!srcDir.isDirectory()) {
            throw new RuntimeIOException("Source directory " + srcDir + " exists but is not a directory");
        }
        if (dstDir.exists()) {
            if (!dstDir.isDirectory()) {
                throw new RuntimeIOException("Destination directory " + dstDir + " already exists and is not a directory");
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("About to copy files into existing directory " + dstDir));
            }
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Creating destination directory " + dstDir));
            }
            dstDir.mkdir();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Copying contents of directory " + srcDir + " to " + dstDir));
        }
        List<HostFile> srcFiles = srcDir.listFiles();
        for (HostFile srcFile : srcFiles) {
            HostFile dstFile = dstDir.getFile(srcFile.getName());
            HostFileUtils.copy(srcFile, dstFile, transformer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void putStringToHostFile(String sourceString, HostFile targetFile) {
        byte[] bytes;
        try {
            bytes = sourceString.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException exc) {
            throw new RuntimeIOException(exc);
        }
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        try {
            targetFile.put(in, bytes.length);
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    public static String getHostFileAsString(HostFile sourceHostFile) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            sourceHostFile.get(bos);
            byte[] contentBytes = bos.toByteArray();
            String string = new String(contentBytes, HostFileUtils.guessCharset(contentBytes));
            return string;
        }
        catch (UnsupportedEncodingException exc) {
            throw new RuntimeIOException(exc);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)bos);
        }
    }

    private static String guessCharset(byte[] rawContent) {
        byte[] rawContentFirstBytes = ArrayUtils.subarray((byte[])rawContent, (int)0, (int)2);
        boolean looksLikeUTF16LE = Arrays.equals(rawContentFirstBytes, UTF16LE_PREAMABLE);
        boolean looksLikeUTF16BE = Arrays.equals(rawContentFirstBytes, UTF16BE_PREAMABLE);
        return looksLikeUTF16LE || looksLikeUTF16BE ? "UTF-16" : "UTF-8";
    }

    public static void unzip(HostFile zip, HostFile dir) {
        HostFileUtils.unzip(zip, dir, null);
    }

    public static void unzip(HostFile zip, HostFile dir, HostFileInputStreamTransformer transformer) {
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException(dir + " is not a directory");
        }
        if (transformer == null) {
            HostFileUtils.unzip(zip.getPath(), zip.get(), dir);
        } else {
            HostFileUtils.unzip(zip.getPath(), transformer.transform(zip), dir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unzip(String zipPath, InputStream zipStream, HostFile dstDir) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Unzipping " + zipPath + " to " + dstDir));
        }
        ZipInputStream zipIn = new ZipInputStream(zipStream);
        try {
            try {
                ZipEntry entry;
                while ((entry = zipIn.getNextEntry()) != null) {
                    HostFileUtils.extractZipEntry(zipIn, entry, dstDir);
                }
            }
            catch (IOException exc) {
                throw new RuntimeIOException("Cannot unzip " + zipPath + " to " + dstDir, exc);
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)zipIn);
        }
    }

    private static void extractZipEntry(ZipInputStream zipIn, ZipEntry entry, HostFile dir) {
        Object[] pathElements = StringUtils.split((String)entry.getName(), (String)"/");
        String dstFileSeparator = dir.getSession().getHostOperatingSystem().getFileSeparator();
        String dstPath = StringUtils.join((Object[])pathElements, (String)dstFileSeparator);
        HostFile dstFile = dir.getFile(dstPath);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Unzipping " + entry.getName() + " to " + dstFile.getPath()));
        }
        if (entry.isDirectory()) {
            dstFile.mkdirs();
        } else {
            dstFile.getParentFile().mkdirs();
            dstFile.put(zipIn, entry.getSize());
        }
    }

    private static ByteArrayOutputStream readIntoByteArrayOutputStream(HostFile srcFile, InputStream inputStream) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            int value;
            while ((value = inputStream.read()) != -1) {
                outputStream.write(value);
            }
        }
        catch (IOException e) {
            throw new RuntimeIOException("Unable to read bytes from Inputstream for file " + srcFile, e);
        }
        return outputStream;
    }

    public static void untar(HostFile tar, HostFile dir) {
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException(dir + " is not a directory");
        }
        HostFileUtils.untar(tar.getPath(), tar.get(), dir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void untar(String tarPath, InputStream zipStream, HostFile dstDir) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Untarring " + tarPath + " to " + dstDir));
        }
        TarInputStream tarIn = new TarInputStream(zipStream);
        try {
            try {
                TarEntry entry;
                while ((entry = tarIn.getNextEntry()) != null) {
                    HostFileUtils.extractTarEntry(tarIn, entry, dstDir);
                }
            }
            catch (IOException exc) {
                throw new RuntimeIOException("Cannot untar " + tarPath + " to " + dstDir, exc);
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)tarIn);
        }
    }

    private static void extractTarEntry(TarInputStream tarInputStream, TarEntry entry, HostFile dir) {
        Object[] pathElements = StringUtils.split((String)entry.getName(), (String)"/");
        String dstFileSeparator = dir.getSession().getHostOperatingSystem().getFileSeparator();
        String dstPath = StringUtils.join((Object[])pathElements, (String)dstFileSeparator);
        HostFile dstFile = dir.getFile(dstPath);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Untarring " + entry.getName() + " to " + dstFile.getPath()));
        }
        if (entry.isDirectory()) {
            dstFile.mkdirs();
        } else {
            dstFile.getParentFile().mkdirs();
            dstFile.put((InputStream)tarInputStream, entry.getSize());
        }
    }
}

