/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.ci;

import com.google.common.base.Preconditions;
import com.xebialabs.deployit.BaseConfigurationItem;
import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.ci.Application;
import com.xebialabs.deployit.ci.MiddlewareResource;
import com.xebialabs.deployit.ci.artifact.DeployableArtifact;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ConfigurationItem(description="A package of a certion version of an application, i.e. a grouping of a number of deployable artifact CI's. Contains as its members all the application components that make it up. Is contained by the Application CI of which it supplies a version.")
public class DeploymentPackage
extends BaseConfigurationItem {
    @ConfigurationItemProperty(required=false, description="The version of the application package. Examples; 1.0, 1.2.3, 1.0-SNAPSHOT, 3.4-MILESTONE-RC-3")
    private String version;
    @ConfigurationItemProperty(required=true, description="The application the package is a part of.", asContainment=true)
    private Application application;
    @ConfigurationItemProperty(required=false, description="The set of deployable artifacts that are part of this package", asContainment=true)
    private Set<DeployableArtifact> deployableArtifacts = new HashSet<DeployableArtifact>();
    @ConfigurationItemProperty(description="The set of middleware resources that are part of this package", asContainment=true)
    private Set<MiddlewareResource> middlewareResources = new HashSet<MiddlewareResource>();

    public DeploymentPackage() {
    }

    public DeploymentPackage(DeployableArtifact ... artifacts) {
        StringBuilder labelBuilder = new StringBuilder();
        for (DeployableArtifact each : artifacts) {
            this.addDeployableArtifact(each);
            if (labelBuilder.length() > 0) {
                labelBuilder.append(" and ");
            }
            labelBuilder.append(each);
        }
        this.setLabel("DeploymentPackage containing " + labelBuilder);
    }

    public DeploymentPackage(MiddlewareResource ... resources) {
        StringBuilder labelBuilder = new StringBuilder();
        for (MiddlewareResource each : resources) {
            this.addMiddlewareResource(each);
            if (labelBuilder.length() > 0) {
                labelBuilder.append(" and ");
            }
            labelBuilder.append(each);
        }
        this.setLabel("DeploymentPackage containing " + labelBuilder);
    }

    public Collection<Serializable> getAllMembers() {
        return this.getMembersOfType(Serializable.class);
    }

    public <T extends Serializable> Collection<T> getMembersOfType(final Class<T> ciType) {
        Predicate typeSelector = new Predicate(){

            public boolean evaluate(Object ci) {
                return ciType.isAssignableFrom(ci.getClass());
            }
        };
        Collection members = CollectionUtils.select(this.deployableArtifacts, (Predicate)typeSelector);
        members.addAll(CollectionUtils.select(this.middlewareResources, (Predicate)typeSelector));
        return members;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public Application getApplication() {
        return this.application;
    }

    public void setApplication(Application application) {
        this.application = application;
    }

    public Set<DeployableArtifact> getDeployableArtifacts() {
        return Collections.unmodifiableSet(this.deployableArtifacts);
    }

    public void setDeployableArtifacts(Set<DeployableArtifact> deployableArtifacts) {
        this.deployableArtifacts = deployableArtifacts;
    }

    public void addDeployableArtifact(DeployableArtifact deployableArtifact) {
        this.deployableArtifacts.add((DeployableArtifact)Preconditions.checkNotNull((Object)deployableArtifact));
    }

    public Set<MiddlewareResource> getMiddlewareResources() {
        return Collections.unmodifiableSet(this.middlewareResources);
    }

    public void setMiddlewareResources(Set<MiddlewareResource> middlewareResources) {
        this.middlewareResources = middlewareResources;
    }

    public void addMiddlewareResource(MiddlewareResource middlewareResource) {
        this.middlewareResources.add((MiddlewareResource)Preconditions.checkNotNull((Object)middlewareResource));
    }
}

