/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.hostsession;

import com.xebialabs.deployit.ci.Host;
import com.xebialabs.deployit.ci.HostAccessMethod;
import com.xebialabs.deployit.ci.OperatingSystemFamily;
import com.xebialabs.deployit.ci.UnreachableHost;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.hostsession.TunnelledHostSession;
import com.xebialabs.deployit.hostsession.cifs.CifsTelnetHostSession;
import com.xebialabs.deployit.hostsession.common.AbstractHostSession;
import com.xebialabs.deployit.hostsession.local.LocalHostSession;
import com.xebialabs.deployit.hostsession.ssh.SshInteractiveSudoHostSession;
import com.xebialabs.deployit.hostsession.ssh.SshScpHostSession;
import com.xebialabs.deployit.hostsession.ssh.SshSftpHostSession;
import com.xebialabs.deployit.hostsession.ssh.SshSudoHostSession;
import org.apache.commons.lang.StringUtils;

public class HostSessionFactory {
    public static final int DEFAULT_SSH_PORT = 22;
    public static final int DEFAULT_CONNECTION_TIMEOUT_MS = 120000;

    public static HostSession getHostSession(OperatingSystemFamily osFamily, HostAccessMethod accessMethod, String address, int port, String username, String password, String sudoUsername, String temporaryDirectoryPath) {
        AbstractHostSession s;
        switch (accessMethod) {
            case NONE: {
                throw new IllegalStateException("Cannot connect to a host that has a NONE access method");
            }
            case LOCAL: {
                s = new LocalHostSession(osFamily, temporaryDirectoryPath);
                break;
            }
            case SSH_SFTP: {
                s = new SshSftpHostSession(osFamily, temporaryDirectoryPath, address, port, username, password);
                break;
            }
            case SSH_SCP: {
                s = new SshScpHostSession(osFamily, temporaryDirectoryPath, address, port, username, password);
                break;
            }
            case SSH_SUDO: {
                s = new SshSudoHostSession(osFamily, temporaryDirectoryPath, address, port, username, password, sudoUsername);
                break;
            }
            case SSH_INTERACTIVE_SUDO: {
                s = new SshInteractiveSudoHostSession(osFamily, temporaryDirectoryPath, address, port, username, password, sudoUsername);
                break;
            }
            case CIFS_TELNET: {
                s = new CifsTelnetHostSession(osFamily, temporaryDirectoryPath, address, port, username, password);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown host access method " + (Object)((Object)accessMethod));
            }
        }
        return s;
    }

    public static HostSession getHostSession(OperatingSystemFamily osFamily, HostAccessMethod accessMethod, String hostSpecification, String username, String password, String sudoUsername, String temporaryDirectoryPath) {
        int port;
        String address;
        if (StringUtils.isBlank((String)hostSpecification)) {
            address = "localhost";
            port = -1;
        } else {
            int pos = hostSpecification.indexOf(58);
            if (pos > 0 && pos < hostSpecification.length()) {
                address = hostSpecification.substring(0, pos);
                try {
                    port = Integer.parseInt(hostSpecification.substring(pos + 1));
                }
                catch (NumberFormatException ignore) {
                    throw new IllegalArgumentException("Host specification " + hostSpecification + " has an invalid port number");
                }
            } else {
                address = hostSpecification;
                port = 22;
            }
        }
        if (temporaryDirectoryPath == null || temporaryDirectoryPath.length() == 0) {
            temporaryDirectoryPath = HostSessionFactory.getDefaultTemporaryDirectoryPath(osFamily, accessMethod);
        }
        return HostSessionFactory.getHostSession(osFamily, accessMethod, address, port, username, password, sudoUsername, temporaryDirectoryPath);
    }

    public static HostSession getHostSession(Host host) {
        if (host instanceof UnreachableHost) {
            return new TunnelledHostSession((UnreachableHost)host);
        }
        return HostSessionFactory.getHostSession(host.getOperatingSystemFamily(), host.getAccessMethod(), host.getAddress(), host.getUsername(), host.getPassword(), host.getSudoUsername(), host.getTemporaryDirectoryLocation());
    }

    private static String getDefaultTemporaryDirectoryPath(OperatingSystemFamily osFamily, HostAccessMethod accessMethod) {
        if (accessMethod == HostAccessMethod.LOCAL) {
            return System.getProperty("java.io.tmpdir", osFamily.getDefaultTemporaryDirectoryPath());
        }
        return osFamily.getDefaultTemporaryDirectoryPath();
    }
}

