package com.xebialabs.deployit.ci.artifact;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Collections;
import java.util.List;

/**
 * Represents a {@link Folder} containing SQL files.
 * They are sorted using natural path order.
 */
@SuppressWarnings("serial")
@ConfigurationItem(description = "Folder in the Application Package containing sql files. Might contain sub folders")
public class SqlFolder extends Folder {

	@ConfigurationItemProperty(required = false, description = "Default is .sql")
	private String filter = ".sql";

	private transient final FilenameFilter sqlFilenameFilter = new FilenameFilter() {
		public boolean accept(File file, String name) {
			return name.toLowerCase().endsWith(filter);
		}
	};

	private transient final FilenameFilter directoryOnly = new FilenameFilter() {
		public boolean accept(java.io.File dir, String name) {
			return new File(dir, name).isDirectory();
		}
	};


	/**
	 * Return all the files, recursively
	 *
	 * @return
	 */
	@Override
	public List<File> getFiles() {
		List<File> allfiles = getSqlFiles(new File(getLocation()));
		Collections.sort(allfiles);
		return allfiles;
	}

	private List<File> getSqlFiles(File folder) {
		List<File> allfiles = Lists.newArrayList(folder.listFiles(sqlFilenameFilter));
		for (File file : folder.listFiles(directoryOnly)) {
			allfiles.addAll(getSqlFiles(file));
		}
		return allfiles;
	}
}