/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.hostsession.common;

import com.xebialabs.deployit.ci.OperatingSystemFamily;
import com.xebialabs.deployit.exception.RuntimeIOException;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostSession;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Random;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.core.io.Resource;

public abstract class AbstractHostSession
implements HostSession {
    private OperatingSystemFamily os;
    private String temporaryDirectoryPath;
    private HostFile sessionTemporaryDirectory;
    public static final long MAX_TEMP_RETRIES = 100L;
    private static Logger logger = Logger.getLogger(AbstractHostSession.class);

    public AbstractHostSession(OperatingSystemFamily os, String temporaryDirectoryPath) {
        this.os = os;
        this.temporaryDirectoryPath = temporaryDirectoryPath;
    }

    public OperatingSystemFamily getHostOperatingSystem() {
        return this.os;
    }

    public String encodeCommandLineForExecution(String ... cmdarray) {
        return this.os.encodeCommandLineForExecution(cmdarray);
    }

    public String encodeCommandLineForLogging(String ... cmdarray) {
        return this.os.encodeCommandLineForLogging(cmdarray);
    }

    public void close() {
        boolean doNotCleanUp;
        String doNotCleanUpTemporaryFiles = System.getProperty("com.xebia.ad.donotcleanuptemporaryfiles");
        boolean bl = doNotCleanUp = doNotCleanUpTemporaryFiles != null && doNotCleanUpTemporaryFiles.equalsIgnoreCase("true");
        if (!doNotCleanUp) {
            this.cleanupTemporaryFiles();
        }
    }

    protected synchronized HostFile getTemporaryDirectory() throws RuntimeIOException {
        if (this.sessionTemporaryDirectory == null) {
            HostFile temporaryDirectory = this.getFile(this.temporaryDirectoryPath);
            Random r = new Random();
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd'T'HHmmssSSS");
            String prefix = "deployit-" + dateFormat.format(new Date());
            String infix = "";
            String suffix = ".tmp";
            int i = 0;
            while ((long)i < 100L) {
                HostFile tempDir = this.createSessionTempDirectory(temporaryDirectory, prefix + infix + suffix);
                if (tempDir != null) {
                    this.sessionTemporaryDirectory = tempDir;
                    logger.info((Object)("Created session temporary directory " + this.sessionTemporaryDirectory));
                    return this.sessionTemporaryDirectory;
                }
                infix = "-" + Long.toString(Math.abs(r.nextLong()));
                ++i;
            }
            throw new RuntimeIOException("Cannot create session temporary directory on " + this);
        }
        return this.sessionTemporaryDirectory;
    }

    protected HostFile createSessionTempDirectory(HostFile systemTempDirectory, String name) {
        HostFile f = this.getFile(systemTempDirectory, name);
        if (!f.exists()) {
            f.mkdir();
            return f;
        }
        return null;
    }

    public void cleanupTemporaryFiles() {
        if (this.sessionTemporaryDirectory != null) {
            try {
                this.sessionTemporaryDirectory.deleteRecursively();
                logger.info((Object)("Removed session temporary directory " + this.sessionTemporaryDirectory));
            }
            catch (RuntimeException exc) {
                logger.warn((Object)("Got exception while removing session temporary directory " + this.sessionTemporaryDirectory), (Throwable)exc);
            }
        }
    }

    public HostFile getTempFile(String nameTemplate) throws RuntimeIOException {
        String suffix;
        String prefix;
        if (nameTemplate != null) {
            int pos = nameTemplate.lastIndexOf(47);
            if (pos != -1) {
                nameTemplate = nameTemplate.substring(pos + 1);
            }
            if ((pos = nameTemplate.lastIndexOf(92)) != -1) {
                nameTemplate = nameTemplate.substring(pos + 1);
            }
        }
        if (StringUtils.isBlank((String)nameTemplate)) {
            prefix = "hostsession";
            suffix = ".tmp";
        } else {
            prefix = FilenameUtils.getBaseName((String)nameTemplate);
            suffix = "." + FilenameUtils.getExtension((String)nameTemplate);
        }
        return this.getTempFile(prefix, suffix);
    }

    public HostFile copyToTemporaryFile(File localFile) throws RuntimeIOException {
        HostFile t = this.getTempFile(localFile.getName());
        t.put(localFile);
        return t;
    }

    public HostFile copyToTemporaryFile(Resource resource) throws RuntimeIOException {
        HostFile t = this.getTempFile(resource.getFilename());
        t.put(resource);
        return t;
    }
}

