/*
 * Copyright (c) 2008-2011 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.reflect;

import static com.google.common.base.Preconditions.checkNotNull;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;

import org.apache.log4j.Logger;

import com.xebialabs.deployit.ConfigurationItem;

/**
 * Creates {@link ConfigurationItemDescriptor}s for types.
 */
public class ConfigurationItemDescriptorFactory {

	private static AtomicReference<ConfigurationItemDescriptorFactoryHelper> INSTANCE = new AtomicReference<ConfigurationItemDescriptorFactoryHelper>();

	private static Map<Class<?>, ConfigurationItemDescriptor> cachedDescriptors = new ConcurrentHashMap<Class<?>, ConfigurationItemDescriptor>();

	/**
	 * Used by Spring. Do not invoke!
	 */
	public ConfigurationItemDescriptorFactory(ConfigurationItemDescriptorFactoryHelper instance) {
		if (INSTANCE.getAndSet(checkNotNull(instance)) != null) {
			log.warn("Attempted to reinitialize holder with " + instance);
		}
	}

	/**
	 * Gets the descriptor for a certain configuration item.
	 * 
	 * @param configurationItem
	 *            the configuration item for which to get the descriptor.
	 * @return the descriptor or <tt>null</tt> if no descriptor can be found for the configuration item.
	 */
	public static ConfigurationItemDescriptor getDescriptor(Serializable configurationItem) {

		ConfigurationItemDescriptor configurationItemDescriptor;
		if (INSTANCE.get() != null) {
			configurationItemDescriptor = INSTANCE.get().getDescriptor(configurationItem);
		} else {
			// TODO: Get defaults! and move code to other class
			Class<?> configurationItemClass;
			if (configurationItem instanceof ConfigurationItemProxy) {
				configurationItemClass = ((ConfigurationItemProxy) configurationItem).getBackingObject().getClass();
			} else {
				configurationItemClass = configurationItem.getClass();
			}
			if (!cachedDescriptors.containsKey(configurationItemClass) && (configurationItemClass.getAnnotation(ConfigurationItem.class) != null)) {
				cachedDescriptors.put(configurationItemClass, new ConfigurationItemDescriptor(configurationItemClass, new HashMap<String, String>()));
			}
			configurationItemDescriptor = cachedDescriptors.get(configurationItemClass);
		}
		return configurationItemDescriptor;
	}

	private final Logger log = Logger.getLogger(ConfigurationItemDescriptorFactory.class);

}
