/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.util;

import org.apache.commons.lang.StringUtils;

public class Encoder {
    public static String encodeCommandLine(boolean hidePassword, String ... commandLine) {
        if (commandLine == null || commandLine.length == 0) {
            throw new IllegalStateException("Cannot execute an empty command line");
        }
        if (commandLine.length == 1 && commandLine[0] != null && commandLine[0].contains(" ")) {
            return Encoder.encodeCommandLine(hidePassword, commandLine[0].split(" "));
        }
        StringBuilder sb = new StringBuilder();
        boolean passwordKeywordSeen = false;
        for (int i = 0; i < commandLine.length; ++i) {
            int j;
            if (i != 0) {
                sb.append(' ');
            }
            if (commandLine[i] == null) {
                sb.append("null");
                continue;
            }
            if (commandLine[i].length() == 0) {
                sb.append("\" \"");
                continue;
            }
            if (passwordKeywordSeen && hidePassword) {
                for (j = 0; j < commandLine[i].length(); ++j) {
                    sb.append("*");
                }
            } else {
                for (j = 0; j < commandLine[i].length(); ++j) {
                    char c = commandLine[i].charAt(j);
                    if ("'\"\\;()${}".indexOf(c) != -1) {
                        sb.append('\\');
                    }
                    sb.append(c);
                }
            }
            passwordKeywordSeen = StringUtils.endsWithIgnoreCase((String)commandLine[i], (String)"password");
        }
        return sb.toString();
    }
}

