/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.hostsession.ssh;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import com.xebialabs.deployit.ci.OperatingSystemFamily;
import com.xebialabs.deployit.exception.RuntimeIOException;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.ssh.SshHostFile;
import com.xebialabs.deployit.hostsession.ssh.SshSftpHostSession;
import com.xebialabs.deployit.hostsession.ssh.SshSftpInputStream;
import com.xebialabs.deployit.hostsession.ssh.SshSftpOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SshSftpHostFile
extends SshHostFile {
    private SshSftpHostSession sshSftpHostSession;
    private static Logger logger = Logger.getLogger(SshSftpHostFile.class);

    public SshSftpHostFile(SshSftpHostSession session, String remotePath) {
        super(session, remotePath);
        this.sshSftpHostSession = session;
    }

    protected SftpATTRS stat() throws RuntimeIOException {
        try {
            SftpATTRS attrs = this.sshSftpHostSession.getSharedSftpChannel().stat(this.convertWindowsPathToWinSshdPath(this.remotePath));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Statted file " + this));
            }
            return attrs;
        }
        catch (SftpException exc) {
            throw new RuntimeIOException("Cannot stat file " + this, exc);
        }
        catch (JSchException exc) {
            throw new RuntimeIOException("Cannot stat file " + this, exc);
        }
    }

    @Override
    public boolean exists() throws RuntimeIOException {
        try {
            this.sshSftpHostSession.getSharedSftpChannel().stat(this.convertWindowsPathToWinSshdPath(this.remotePath));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Checked file " + this.remotePath + " for existence and found it"));
            }
            return true;
        }
        catch (SftpException exc) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Checked file " + this.remotePath + " for existence and did not find it"));
            }
            return false;
        }
        catch (JSchException exc) {
            throw new RuntimeIOException("Cannot check existence of file " + this.remotePath, exc);
        }
    }

    @Override
    public boolean isDirectory() throws RuntimeIOException {
        return this.stat().isDir();
    }

    @Override
    public long length() throws RuntimeIOException {
        return this.stat().getSize();
    }

    @Override
    public boolean canExecute() throws RuntimeIOException {
        SftpATTRS attrs = this.stat();
        return (attrs.getPermissions() & 0x40) != 0;
    }

    @Override
    public boolean canRead() throws RuntimeIOException {
        SftpATTRS attrs = this.stat();
        return (attrs.getPermissions() & 0x100) != 0;
    }

    @Override
    public boolean canWrite() throws RuntimeIOException {
        SftpATTRS attrs = this.stat();
        return (attrs.getPermissions() & 0x80) != 0;
    }

    @Override
    public List<String> list() throws RuntimeIOException {
        try {
            Vector ls = this.sshSftpHostSession.getSharedSftpChannel().ls(this.convertWindowsPathToWinSshdPath(this.remotePath));
            ArrayList<String> filenames = new ArrayList<String>(ls.size());
            for (ChannelSftp.LsEntry lsEntry : ls) {
                String filename = lsEntry.getFilename();
                if (filename.equals(".") || filename.equals("..")) continue;
                filenames.add(filename);
            }
            return filenames;
        }
        catch (SftpException exc) {
            throw new RuntimeIOException("Cannot list directory " + this + ": " + exc.toString(), exc);
        }
        catch (JSchException exc) {
            throw new RuntimeIOException("Cannot list directory " + this + ": " + exc.toString(), exc);
        }
    }

    @Override
    public void mkdir() throws RuntimeIOException {
        try {
            String compatibleRemotePath = this.convertWindowsPathToWinSshdPath(this.remotePath);
            this.sshSftpHostSession.getSharedSftpChannel().mkdir(compatibleRemotePath);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Created directory " + this.remotePath));
            }
        }
        catch (SftpException exc) {
            throw new RuntimeIOException("Cannot create directory " + this.remotePath + ": " + exc.toString(), exc);
        }
        catch (JSchException exc) {
            throw new RuntimeIOException("Cannot create directory " + this.remotePath + ": " + exc.toString(), exc);
        }
    }

    @Override
    public void mkdirs() throws RuntimeIOException {
        ArrayList<SshSftpHostFile> allDirs = new ArrayList<SshSftpHostFile>();
        HostFile dir = this;
        do {
            allDirs.add(0, (SshSftpHostFile)dir);
        } while ((dir = dir.getParentFile()) != null);
        for (HostFile hostFile : allDirs) {
            if (hostFile.exists()) continue;
            hostFile.mkdir();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void moveTo(HostFile destFile) {
        if (!(destFile instanceof SshSftpHostFile)) throw new RuntimeIOException("Cannot move/rename SSH/SCP file/directory " + this + " to non-SSH/SCP file/directory " + destFile);
        SshSftpHostFile sshSftpDestFile = (SshSftpHostFile)destFile;
        if (sshSftpDestFile.getSession() != this.getSession()) throw new RuntimeIOException("Cannot move/rename SSH/SCP file/directory " + this + " to SSH/SCP file/directory " + destFile + " because it is in a different session");
        try {
            this.sshSftpHostSession.getSharedSftpChannel().rename(this.remotePath, sshSftpDestFile.getPath());
            return;
        }
        catch (SftpException exc) {
            throw new RuntimeIOException("Cannot move/rename file/directory " + this + " to " + destFile + ": " + exc.toString(), exc);
        }
        catch (JSchException exc) {
            throw new RuntimeIOException("Cannot move/rename file/directory " + this + " to " + destFile + ": " + exc.toString(), exc);
        }
    }

    @Override
    protected void deleteFile() {
        try {
            this.sshSftpHostSession.getSharedSftpChannel().rm(this.convertWindowsPathToWinSshdPath(this.remotePath));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Removed file " + this));
            }
        }
        catch (SftpException exc) {
            throw new RuntimeIOException("Cannot delete file " + this + ": " + exc.toString(), exc);
        }
        catch (JSchException exc) {
            throw new RuntimeIOException("Cannot delete file " + this + ": " + exc.toString(), exc);
        }
    }

    @Override
    protected void deleteDirectory() {
        try {
            this.sshSftpHostSession.getSharedSftpChannel().rmdir(this.convertWindowsPathToWinSshdPath(this.remotePath));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Removed directory " + this));
            }
        }
        catch (SftpException exc) {
            throw new RuntimeIOException("Cannot delete directory " + this + ": " + exc.toString(), exc);
        }
        catch (JSchException exc) {
            throw new RuntimeIOException("Cannot delete directory " + this + ": " + exc.toString(), exc);
        }
    }

    @Override
    public InputStream get() throws RuntimeIOException {
        try {
            ChannelSftp sftpChannel = this.sshSftpHostSession.openSftpChannel();
            SshSftpInputStream in = new SshSftpInputStream(this.sshSftpHostSession, sftpChannel, sftpChannel.get(this.convertWindowsPathToWinSshdPath(this.remotePath)));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Opened SFTP input stream to read from file " + this));
            }
            return in;
        }
        catch (SftpException exc) {
            throw new RuntimeIOException("Cannot read from file " + this.remotePath + ": " + exc.toString(), exc);
        }
        catch (JSchException exc) {
            throw new RuntimeIOException("Cannot read from file " + this.remotePath + ": " + exc.toString(), exc);
        }
    }

    @Override
    public void get(OutputStream out) throws RuntimeIOException {
        try {
            this.sshSftpHostSession.getSharedSftpChannel().get(this.convertWindowsPathToWinSshdPath(this.remotePath), out);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Wrote output stream from file " + this));
            }
        }
        catch (SftpException exc) {
            throw new RuntimeIOException("Cannot read from file " + this.remotePath + ": " + exc.toString(), exc);
        }
        catch (JSchException exc) {
            throw new RuntimeIOException("Cannot read from file " + this.remotePath + ": " + exc.toString(), exc);
        }
    }

    @Override
    public OutputStream put(long length) throws RuntimeIOException {
        try {
            ChannelSftp sftpChannel = this.sshSftpHostSession.openSftpChannel();
            SshSftpOutputStream out = new SshSftpOutputStream(this.sshSftpHostSession, sftpChannel, sftpChannel.put(this.convertWindowsPathToWinSshdPath(this.remotePath)));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Opened SFTP ouput stream to write to file " + this));
            }
            return out;
        }
        catch (SftpException exc) {
            throw new RuntimeIOException("Cannot write to file " + this.remotePath + ": " + exc.toString(), exc);
        }
        catch (JSchException exc) {
            throw new RuntimeIOException("Cannot write to file " + this.remotePath + ": " + exc.toString(), exc);
        }
    }

    @Override
    public void put(InputStream in, long length) throws RuntimeIOException {
        try {
            this.sshSftpHostSession.getSharedSftpChannel().put(in, this.convertWindowsPathToWinSshdPath(this.remotePath));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Wrote input stream to file " + this));
            }
        }
        catch (SftpException exc) {
            throw new RuntimeIOException("Cannot write to file " + this.remotePath + ": " + exc.toString(), exc);
        }
        catch (JSchException exc) {
            throw new RuntimeIOException("Cannot write to file " + this.remotePath + ": " + exc.toString(), exc);
        }
    }

    private String convertWindowsPathToWinSshdPath(String path) {
        if (this.getSession().getHostOperatingSystem() == OperatingSystemFamily.WINDOWS) {
            String winSshdPath = path.length() == 2 && path.charAt(1) == ':' ? "/" + path.charAt(0) : (path.length() > 2 && path.charAt(1) == ':' && path.charAt(2) == '\\' ? "/" + path.replace('\\', '/').replace(":", "") : path);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Translated Windows path " + path + " to WinSSHD path " + winSshdPath));
            }
            path = winSshdPath;
        }
        return path;
    }
}

