/*
 * Copyright (c) 2008-2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.step;

import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.ci.Host;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostFileUtils;
import com.xebialabs.deployit.hostsession.HostSession;

@SuppressWarnings("serial")
public class HostConnectionStep implements Step {

	protected final Host host;

	public HostConnectionStep(Host host) {
		this.host = host;
	}

	public boolean execute(StepExecutionContext ctx) {
		try {
			HostSession rhs = host.getHostSession();
			try {
				HostFile fileToUpload = uploadFile(rhs);
				tryCanGetFilePermissions(rhs, fileToUpload);
			} finally {
				rhs.close();
			}
		} catch (Exception exc) {
			ctx.logError("Connection test to host " + host + " failed. Please check address, username and password", exc);
			return false;
		}
		ctx.logOutput("Connection test to host " + host + " succeeded");
		return true;
	}

	private HostFile uploadFile(HostSession rhs) {
		HostFile fileToUpload = rhs.getTempFile("hostconnection-remote", ".txt");
		HostFileUtils.putStringToHostFile("Contents of host connection test file", fileToUpload);
		return fileToUpload;
	}

	private void tryCanGetFilePermissions(HostSession rhs, HostFile fileToUpload) {
		HostFile filesJustUploadedNotAsATempFile = rhs.getFile(fileToUpload.getPath());
		if (!filesJustUploadedNotAsATempFile.canRead()) {
			throw new RuntimeException("Cannot check read permission for file just uploaded");
		}
	}

	public String getDescription() {
		return "Test connection to " + host;
	}

}
