/*
 * Copyright (c) 2008-2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.ci.artifact.mapping;

import java.util.List;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.log4j.Logger;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.ci.Host;
import com.xebialabs.deployit.ci.artifact.ConfigurationFiles;
import com.xebialabs.deployit.ci.mapping.KeyValuePair;

/**
 * A mapping of a {@link ConfigurationFiles} configuration item to a {@link Host}.
 */
@SuppressWarnings("serial")
@ConfigurationItem(description = "A mapping of a ConfigurationFiles CI to a Host")
public class ConfigurationFilesMapping extends DeployableArtifactMapping<ConfigurationFiles, Host> {

	public static final String TARGET_DIRECTORY_KEY_NAME = "TARGET_DIRECTORY";

	@ConfigurationItemProperty(required = true, description = "The directory on the target host to which the configuration is to be copied. Non-existent directories on the path will be created. Example: /data/petclinic/1.0/conf")
	private String targetDirectory;

	@ConfigurationItemProperty(required = false, description = "The target directory is shared when another resources using it as well.")
	private boolean shared;

	public ConfigurationFilesMapping() {
		// default constructor
	}

	public ConfigurationFilesMapping(ConfigurationFiles source, Host target, String targetDirectory) {
		super(source, target);
		this.targetDirectory = targetDirectory;
	}

	@Override
	public List<KeyValuePair> getKeyValuePairs() {
		List<KeyValuePair> kvps = Lists.newArrayList(super.getKeyValuePairs());
		Object existingTargetDirectoryKvp = CollectionUtils.find(kvps, new Predicate() {
			public boolean evaluate(Object each) {
				return ((KeyValuePair) each).getKey().equals(TARGET_DIRECTORY_KEY_NAME);
			}
		});

		if (existingTargetDirectoryKvp == null) {
			kvps.add(new KeyValuePair(TARGET_DIRECTORY_KEY_NAME, getTargetDirectory()));
		} else {
			logger.warn("ConfigurationFilesMapping " + this + " already contains a key/value pair for key " + TARGET_DIRECTORY_KEY_NAME
					+ ". Not overriding it.");
		}
		return kvps;
	}

	public String getTargetDirectory() {
		return targetDirectory;
	}

	public void setTargetDirectory(String targetDirectory) {
		this.targetDirectory = targetDirectory;
	}

	public boolean isShared() {
		return shared;
	}

	public void setShared(boolean shared) {
		this.shared = shared;
	}

	private static Logger logger = Logger.getLogger(ConfigurationFilesMapping.class);

}
