/*
 * Copyright (c) 2008-2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit;

import java.util.Map;


public interface Discoverable<T> {

	/**
	 * Try to 'discover' the primitive properties of a CI as found in Reality.
	 * 
	 * When a CI implements this, the actual revision of the CI can be asked to 'discover' itself.
	 * It is used to check the contents of the CI Repository against the 'real' world. This can be
	 * used to capture manual changes that were performed outside Deployit. 
	 * 
	 * For example, when JVM settings on a WasCluster indicate 256Meg max heap space, but someone
	 * manually changed this to 512Meg, the CI in the repository will indicate 256Meg,
	 * but the returned ("discovered") version will return 512Meg. 
	 * 
	 * @return the CI as found in Reality.
	 */
	T discover(Map<String, Object> info, ChangePlan cp);
	
	/**
	 * Like discover(), now retrieve additional information about children and pass that back to the caller
	 * 
	 * @param info
	 * @return
	 */
	T discoverChildrenInfo(Map<String, Object> info, ChangePlan cp);
	
}
