/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit;

import com.google.common.base.Preconditions;
import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.Step;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeResolution {
    private Set<Change<?>> changes = new HashSet();
    private List<Step> steps = new ArrayList<Step>();

    public ChangeResolution() {
    }

    public ChangeResolution(Change<?> c) {
        this.changes.add((Change<?>)Preconditions.checkNotNull(c, (Object)"Change may not be null"));
    }

    public ChangeResolution(Change<?> c, List<Step> steps) {
        this.changes.add((Change<?>)Preconditions.checkNotNull(c, (Object)"Change may not be null"));
        this.steps.addAll((Collection)Preconditions.checkNotNull(steps, (Object)"List of Steps may not be null"));
    }

    public Set<Change<?>> getChanges() {
        return Collections.unmodifiableSet(this.changes);
    }

    public List<Step> getSteps() {
        return Collections.unmodifiableList(this.steps);
    }

    public void addChange(Change<?> changeToAdd) {
        this.changes.add((Change<?>)Preconditions.checkNotNull(changeToAdd, (Object)"Change may not be null"));
    }

    public void addStep(Step stepToAdd) {
        this.steps.add((Step)Preconditions.checkNotNull((Object)stepToAdd, (Object)"Step may not be null"));
    }

    public void addSteps(List<Step> stepsToAdd) {
        this.steps.addAll((Collection)Preconditions.checkNotNull(stepsToAdd, (Object)"List of Steps may not be null"));
    }
}

