/*
 * Copyright (c) 2008-2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.util;

import org.apache.commons.lang.StringUtils;

/**
 * Created by IntelliJ IDEA.
 * User: bmoussaud
 * Date: 25 ao�t 2010
 * Time: 08:24:45
 * To change this template use File | Settings | File Templates.
 */
public class Encoder {
	public static String encodeCommandLine(boolean hidePassword, String... commandLine) {
	    if (commandLine == null || commandLine.length == 0) {
	        throw new IllegalStateException("Cannot execute an empty command line");
	    }

		if (commandLine.length == 1 && commandLine[0] != null && commandLine[0].contains(" ")) {
			return encodeCommandLine(hidePassword, commandLine[0].split(" "));

		}
	    StringBuilder sb = new StringBuilder();
	    boolean passwordKeywordSeen = false;
	    for (int i = 0; i < commandLine.length; i++) {
	        if (i != 0) {
	            sb.append(' ');
	        }
	        if (commandLine[i] == null) {
	            sb.append("null");
	        } else if (commandLine[i].length() == 0) {
	            sb.append("\" \"");
	        } else {
	            if (passwordKeywordSeen && hidePassword) {
	                for (int j = 0; j < commandLine[i].length(); j++) {
	                    sb.append("*");
	                }
	            } else {
	                for (int j = 0; j < commandLine[i].length(); j++) {
	                    char c = commandLine[i].charAt(j);
	                    if ("'\"\\;()${}".indexOf(c) != -1) {
	                        sb.append('\\');
	                    }
	                    sb.append(c);
	                }
	            }
	            // catch 'password' or '-password'
	            passwordKeywordSeen = StringUtils.endsWithIgnoreCase(commandLine[i], "password");
	        }
	    }
	    return sb.toString();
	}
}
