/*
 * Copyright (c) 2008-2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.mapper;

import java.io.Serializable;
import java.util.List;

import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.ci.mapping.Mapping;

/**
 * A subclass of {@link StepGeneratingMapper} that provides the same functionality but does not pass the mapping object
 * to the template methods.
 * 
 * @param <S>
 *            the type of the source artifact/resource.
 * @param <T>
 *            the type of the target middleware.
 */
public abstract class MappingAgnosticStepGeneratingMapper<S extends Serializable, M extends Mapping<? super S, ? super T>, T extends Serializable> extends
		StepGeneratingMapper<S, M, T> {

	/**
	 * Creates a <tt>MappingAgnosticStepGeneratingMapper</tt> for the specified deployment change.
	 * 
	 * @param change
	 *            the deployment change for which to calculate mappings.
	 * @param applyDefaultMappings
	 *            default mappings will be applied iff <code>true</code>
	 */
	public MappingAgnosticStepGeneratingMapper(Change<Deployment> change, boolean applyDefaultMappings) {
		super(change, applyDefaultMappings);
	}

	/**
	 * Creates a <tt>MappingAgnosticStepGeneratingMapper</tt> for the specified deployment change that will <em>not</em>
	 * apply default mappings.
	 * 
	 * @param change
	 *            the deployment change for which to calculate mappings.
	 */
	public MappingAgnosticStepGeneratingMapper(Change<Deployment> change) {
		super(change);
	}
	
	/**
	 * Overrides
	 * {@link StepGeneratingMapper#generateAdditionStepsForAddedMapping(Serializable, Mapping, Serializable, List)} to
	 * invoke {@link #generateAdditionStepsForAddedMapping(Serializable, Serializable, List)}.
	 */
	@Override
	protected final void generateAdditionStepsForAddedMapping(S newMappingSource, M newMapping, T newMappingTarget, List<Step> steps) {
		generateAdditionStepsForAddedMapping(newMappingSource, newMappingTarget, steps);
	}

	/**
	 * Version of
	 * {@link StepGeneratingMapper#generateAdditionStepsForAddedMapping(Serializable, Mapping, Serializable, List)} that
	 * does without the <tt>newMapping</tt> parameter.
	 * 
	 * @param newMappingSource
	 *            the source of the new mapping.
	 * @param newMappingTarget
	 *            the target of the new mapping.
	 * @param steps
	 *            the list of steps to which the generated steps are to be added
	 */
	protected abstract void generateAdditionStepsForAddedMapping(S newMappingSource, T newMappingTarget, List<Step> steps);

	/**
	 * Overrides
	 * {@link StepGeneratingMapper#generateAdditionStepsForModifiedMapping(Serializable, Mapping, Serializable, List)}
	 * to invoke {@link #generateAdditionStepsForModifiedMapping(Serializable, Serializable, List)}.
	 */
	@Override
	protected final void generateAdditionStepsForModifiedMapping(S newMappingSource, M newMapping, T newMappingTarget, List<Step> steps) {
		generateAdditionStepsForModifiedMapping(newMappingSource, newMappingTarget, steps);
	}

	/**
	 * Version of
	 * {@link StepGeneratingMapper#generateAdditionStepsForModifiedMapping(Serializable, Mapping, Serializable, List)}
	 * that does without the <tt>newMapping</tt> parameter. The default implementation invokes
	 * {@link #generateAdditionStepsForAddedMapping(Serializable, Serializable, List)}.
	 * 
	 * @param newMappingSource
	 *            the new source of the modified mapping.
	 * @param newMappingTarget
	 *            the new target of the modified mapping.
	 * @param steps
	 *            the list of steps to which the generated steps are to be added
	 */
	protected void generateAdditionStepsForModifiedMapping(S newMappingSource, T newMappingTarget, List<Step> steps) {
		generateAdditionStepsForAddedMapping(newMappingSource, newMappingTarget, steps);
	}

	/**
	 * Overrides
	 * {@link StepGeneratingMapper#generateDeletionStepsForModifiedMapping(Serializable, Mapping, Serializable, List)}
	 * to invoke {@link #generateDeletionStepsForModifiedMapping(Serializable, Serializable, List)}.
	 */
	@Override
	protected final void generateDeletionStepsForModifiedMapping(S newMappingSource, M newMapping, T newMappingTarget, List<Step> steps) {
		generateDeletionStepsForModifiedMapping(newMappingSource, newMappingTarget, steps);
	}

	/**
	 * Version of
	 * {@link StepGeneratingMapper#generateDeletionStepsForModifiedMapping(Serializable, Mapping, Serializable, List)}
	 * that does without the <tt>oldMapping</tt> parameter. The default implementation invokes
	 * {@link #generateDeletionStepsForDeletedMapping(Serializable, Serializable, List)}.
	 * 
	 * @param oldMappingSource
	 *            the source of the new mapping.
	 * @param oldMappingTarget
	 *            the target of the new mapping.
	 * @param steps
	 *            the list of steps to which the generated steps are to be added
	 */
	protected void generateDeletionStepsForModifiedMapping(S oldMappingSource, T oldMappingTarget, List<Step> steps) {
		generateDeletionStepsForDeletedMapping(oldMappingSource, oldMappingTarget, steps);
	}

	/**
	 * Overrides
	 * {@link StepGeneratingMapper#generateDeletionStepsForDeletedMapping(Serializable, Mapping, Serializable, List)} to
	 * invoke {@link #generateDeletionStepsForDeletedMapping(Serializable, Serializable, List)}.
	 */
	@Override
	protected final void generateDeletionStepsForDeletedMapping(S oldMappingSource, M oldMapping, T oldMappingTarget, List<Step> steps) {
		generateDeletionStepsForDeletedMapping(oldMappingSource, oldMappingTarget, steps);
	}

	/**
	 * Version of
	 * {@link StepGeneratingMapper#generateDeletionStepsForDeletedMapping(Serializable, Mapping, Serializable, List)}
	 * that does without the <tt>oldMapping</tt> parameter.
	 * 
	 * @param oldMappingSource
	 *            the source of the old mapping.
	 * @param oldMappingTarget
	 *            the target of the old mapping.
	 * @param steps
	 *            the list of steps to which the generated steps are to be added
	 */
	protected abstract void generateDeletionStepsForDeletedMapping(S oldMappingSource, T oldMappingTarget, List<Step> steps);

}
