/*
 * Copyright (c) 2008-2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.ci;

import static com.google.common.base.Preconditions.checkNotNull;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

import com.xebialabs.deployit.BaseConfigurationItem;
import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;

/**
 * Represents a collection of middleware CI's that belong together.
 */
@SuppressWarnings("serial")
@ConfigurationItem(description = "A group where middleware CI's can be added, can serve as a target for a deployment.", category = "environments")
public class Environment extends BaseConfigurationItem {

	@ConfigurationItemProperty
	private Set<Serializable> members = new HashSet<Serializable>();

	public Environment() {
		//
	}
	
	public Environment(Serializable... members) {
		HashSet<Serializable> memberSet = new HashSet<Serializable>();
		for(Serializable each : members) {
			memberSet.add(each);
		}
		setMembers(memberSet);
	}

	public Set<Serializable> getMembers() {
		return members;
	}

	@SuppressWarnings("unchecked")
	public <T extends Serializable> Set<T> getMembersOfType(Class<T> classType) {
		Set<T> matchingMembers = new HashSet<T>();
		for (Serializable member : getMembers()) {
			if (classType.isInstance(member)) {
				matchingMembers.add((T) member);
			}
		}
		return matchingMembers;
	}

	public void setMembers(Set<Serializable> members) {
		this.members = members;
	}

	public void addMember(Serializable member) {
		members.add(checkNotNull(member));
	}

}
