/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.steps;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.StepExecutionContextCallbackHandler;
import com.xebialabs.deployit.ci.Host;
import com.xebialabs.deployit.exception.RuntimeIOException;
import com.xebialabs.deployit.hostsession.CommandExecutionCallbackHandler;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostFileUtils;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.hostsession.HostSessionFactory;
import com.xebialabs.deployit.mapper.Pair;
import com.xebialabs.deployit.steps.HostSessionStep;
import com.xebialabs.deployit.util.TemplateResolver;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.FileSystemResourceLoader;
import org.springframework.core.io.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HostCommandExecutionStep
extends HostSessionStep {
    private static final String CLASSPATH_RESOURCE_PROTOCOL = "classpath";
    private static final String FILE_RESOURCE_PROTOCOL = "file";
    private static final String LITERAL_RESOURCE_PROTOCOL = "literal";
    private static final String TEXT_RESOURCE_PROTOCOL = "text";
    private static final String ZIP_RESOURCE_PROTOCOL = "zip";
    public static final String CLASSPATH_RESOURCE_PREFIX = "classpath:";
    public static final String FILE_RESOURCE_PREFIX = "file:";
    public static final String LITERAL_RESOURCE_PREFIX = "literal:";
    public static final String TEXT_RESOURCE_PREFIX = "text:";
    public static final String ZIP_RESOURCE_PREFIX = "zip:";
    public static final String EXECUTING_HOST_COMMAND_DESCRIPTION_PREFIX = "";
    private static final Host LOCALHOST = Host.getLocalHost();
    private String[] command;
    private int expectedResult;
    private Map<String, String> inputResponse;
    private Map<String, String> resourcesToUpload;
    private static Logger logger = Logger.getLogger(HostCommandExecutionStep.class);

    public HostCommandExecutionStep(Host host, String description, int expectedResult, String ... command) {
        this(host, description, expectedResult, new int[0], command);
    }

    public HostCommandExecutionStep(String description, int[] nondisclosableArgIndices, String ... command) {
        this(LOCALHOST, description, 0, nondisclosableArgIndices, command);
    }

    public HostCommandExecutionStep(Host host, String description, int expectedResult, int[] nondisclosableArgIndices, String ... command) {
        super(host);
        this.command = command;
        this.expectedResult = expectedResult;
        this.inputResponse = new HashMap<String, String>();
        this.resourcesToUpload = new HashMap<String, String>();
        this.setDescription(description);
        if (logger.isDebugEnabled()) {
            HostCommandExecutionStep.printDebugCreationMessage(host, nondisclosableArgIndices, command);
        }
    }

    private static void printDebugCreationMessage(Host host, int[] nondisclosableArgIndices, String[] command) {
        if (nondisclosableArgIndices == null) {
            throw new IllegalArgumentException("'nondisclosableArgIndices' may not be null");
        }
        Object[] commandCopy = (String[])command.clone();
        for (int i = 0; i < nondisclosableArgIndices.length; ++i) {
            assert (nondisclosableArgIndices[i] >= 0 && nondisclosableArgIndices[i] < command.length) : new Object[]{nondisclosableArgIndices, command};
            commandCopy[nondisclosableArgIndices[i]] = commandCopy[nondisclosableArgIndices[i]] != null ? StringUtils.repeat((String)"*", (int)((String)commandCopy[nondisclosableArgIndices[i]]).length()) : "****";
        }
        logger.debug((Object)("Created HostCommandExecutionStep for host " + host.getLabel() + ":" + StringUtils.join((Object[])commandCopy, (String)" ")));
    }

    public void setExpectedResult(int expectedResult) {
        this.expectedResult = expectedResult;
    }

    public void addInputResponse(String input, String response) {
        this.inputResponse.put(input, response);
    }

    public void addResourceToUpload(String key, String resourceSpec) {
        this.resourcesToUpload.put(key, resourceSpec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(StepExecutionContext ctx) {
        HostSession s = this.getHostSession();
        try {
            HashMap<String, String> commandVariables = new HashMap<String, String>();
            this.uploadResources(s, commandVariables);
            int res = this.executeCommand(s, commandVariables, ctx);
            boolean bl = res == this.expectedResult;
            return bl;
        }
        finally {
            s.close();
        }
    }

    private void uploadResources(HostSession s, Map<String, String> commandVariables) {
        for (Map.Entry<String, String> each : this.resourcesToUpload.entrySet()) {
            String key = each.getKey();
            String resourceSpec = each.getValue();
            HostFile hostFile = this.uploadResource(s, key, resourceSpec);
            commandVariables.put(key, hostFile.getPath());
        }
    }

    private HostFile uploadResource(HostSession s, String key, String resourceSpec) {
        Pair<String, String> parsedResourceSpec = this.parseResourceSpec(resourceSpec);
        String protocol = parsedResourceSpec.getFirst();
        if (protocol.equals(TEXT_RESOURCE_PROTOCOL)) {
            return this.uploadTextResource(s, resourceSpec);
        }
        if (protocol.equals(ZIP_RESOURCE_PROTOCOL)) {
            throw new RuntimeException("can't handle zips in this step");
        }
        return this.uploadSimpleResource(s, resourceSpec);
    }

    private HostFile uploadSimpleResource(HostSession s, String resourceSpec) {
        Resource resource = this.getResource(resourceSpec);
        HostFile hostFile = s.getTempFile(this.getResourceName(resource));
        try {
            File resourceFile = resource.getFile();
            this.uploadFileResource(hostFile, resourceFile, resourceSpec);
        }
        catch (IOException exc) {
            this.uploadNonFileResource(hostFile, resource, resourceSpec);
        }
        return hostFile;
    }

    private void uploadFileResource(HostFile hostFile, File localFile, String resourceSpec) {
        if (localFile.isDirectory()) {
            this.uploadDirectory(hostFile, localFile, resourceSpec);
        } else {
            this.uploadRegularFile(hostFile, localFile, resourceSpec);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uploadDirectory(HostFile hostFile, File localDir, String resourceSpec) {
        HostSession localSession = HostSessionFactory.getHostSession(Host.getLocalHost());
        try {
            HostFileUtils.copyDirectory(localSession.getFile(localDir.getPath()), hostFile);
        }
        finally {
            localSession.close();
        }
    }

    private void uploadRegularFile(HostFile hostFile, File localFile, String resourceSpec) {
        hostFile.put(localFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uploadNonFileResource(HostFile hostFile, Resource resource, String resourceSpec) {
        try {
            InputStream resourceIn = resource.getInputStream();
            try {
                byte[] resourceBytes = IOUtils.toByteArray((InputStream)resourceIn);
                hostFile.put(new ByteArrayInputStream(resourceBytes), resourceBytes.length);
            }
            finally {
                resourceIn.close();
            }
        }
        catch (IOException exc) {
            throw new RuntimeIOException("Cannot upload non-file resource " + resourceSpec, exc);
        }
    }

    private HostFile uploadTextResource(HostSession s, String resourceSpec) {
        try {
            Pair<String, String> parsedResource = this.parseResourceSpec(resourceSpec);
            assert (parsedResource.getFirst().equals(TEXT_RESOURCE_PROTOCOL));
            String textResourceSpec = parsedResource.getSecond();
            Resource textResource = this.getResource(textResourceSpec);
            String unconvertedText = IOUtils.toString((InputStream)textResource.getInputStream());
            String convertedText = s.getHostOperatingSystem().convertText(unconvertedText);
            byte[] convertedBytes = convertedText.getBytes("UTF-8");
            HostFile hostFile = s.getTempFile(this.getResourceName(textResource));
            hostFile.put(new ByteArrayInputStream(convertedBytes), convertedBytes.length);
            return hostFile;
        }
        catch (IOException exc) {
            throw new RuntimeIOException("Cannot upload text resource " + resourceSpec, exc);
        }
    }

    private Resource getResource(String resourceSpec) {
        Pair<String, String> parsedResourceSpec = this.parseResourceSpec(resourceSpec);
        String protocol = parsedResourceSpec.getFirst();
        String path = parsedResourceSpec.getSecond();
        if (protocol.equals(LITERAL_RESOURCE_PROTOCOL)) {
            try {
                return new ByteArrayResource(path.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException exc) {
                return new ByteArrayResource(path.getBytes());
            }
        }
        FileSystemResourceLoader loader = new FileSystemResourceLoader();
        return loader.getResource(resourceSpec);
    }

    private String getResourceName(Resource resource) {
        try {
            return resource.getFilename();
        }
        catch (IllegalStateException exc) {
            return "unnamed";
        }
    }

    private Pair<String, String> parseResourceSpec(String resourceSpec) {
        int p = resourceSpec.indexOf(58);
        if (p == -1 || p == 0 || p >= resourceSpec.length() - 1) {
            throw new IllegalArgumentException("Invalid resource URL " + resourceSpec);
        }
        return new Pair<String, String>(resourceSpec.substring(0, p), resourceSpec.substring(p + 1));
    }

    private int executeCommand(HostSession s, Map<String, String> commandVariables, StepExecutionContext ctx) {
        StepExecutionContextCallbackHandler handler = new StepExecutionContextCallbackHandler(ctx);
        String[] c = this.replaceVariablesInCommand(this.command, commandVariables);
        return s.execute((CommandExecutionCallbackHandler)handler, this.inputResponse, c);
    }

    private String[] replaceVariablesInCommand(String[] commandIn, Map<String, String> commandVariables) {
        TemplateResolver r = new TemplateResolver(commandVariables);
        String[] commandOut = new String[commandIn.length];
        for (int i = 0; i < commandIn.length; ++i) {
            commandOut[i] = r.resolveStrict(commandIn[i]);
        }
        return commandOut;
    }
}

