/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.mapper.artifact;

import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.ResolutionException;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.ci.Host;
import com.xebialabs.deployit.ci.artifact.ConfigurationFiles;
import com.xebialabs.deployit.ci.artifact.mapping.ConfigurationFilesMapping;
import com.xebialabs.deployit.ci.mapping.KeyValuePair;
import com.xebialabs.deployit.mapper.StepGeneratingMapper;
import com.xebialabs.deployit.steps.CopyStep;
import com.xebialabs.deployit.steps.DeleteStep;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationFilesToHostMapper
extends StepGeneratingMapper<ConfigurationFiles, ConfigurationFilesMapping, Host> {
    public ConfigurationFilesToHostMapper(Change<Deployment> c) {
        super(c, false);
    }

    @Override
    protected void generateAdditionStepsForAddedMapping(ConfigurationFiles newSource, ConfigurationFilesMapping m, Host newTarget, List<Step> steps) {
        if (StringUtils.isBlank((String)m.getTargetDirectory())) {
            throw new ResolutionException("Target directory not specified for mapping " + m);
        }
        Map<String, String> propertyMap = KeyValuePair.toMap(m.getKeyValuePairs());
        steps.add(new CopyStep(Host.getLocalHost(), ((ConfigurationFiles)m.getSource()).getLocation(), (Host)m.getTarget(), m.getTargetDirectory(), propertyMap));
    }

    @Override
    protected void generateDeletionStepsForDeletedMapping(ConfigurationFiles oldSource, ConfigurationFilesMapping m, Host oldTarget, List<Step> steps) {
        if (!m.isShared()) {
            steps.add(new DeleteStep((Host)m.getTarget(), m.getTargetDirectory()));
        } else {
            for (File f : oldSource.getFiles()) {
                String fileToDelete = new File(m.getTargetDirectory(), f.getName()).getPath();
                steps.add(new DeleteStep((Host)m.getTarget(), fileToDelete));
            }
        }
    }
}

