/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.mapper;

import com.google.common.base.Preconditions;
import com.qrmedia.commons.lang.ClassUtils;
import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.ResolutionException;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.ci.mapping.KeyValuePair;
import com.xebialabs.deployit.ci.mapping.Mapping;
import com.xebialabs.deployit.ci.mapping.SourcePropertyOverridingMapping;
import com.xebialabs.deployit.mapper.Pair;
import com.xebialabs.deployit.reflect.ConfigurationItemReflectionUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Mapper<S extends Serializable, M extends Mapping, T extends Serializable> {
    protected Change<Deployment> change;
    protected List<M> oldMappings;
    protected List<M> newMappings;
    protected List<M> addedMappings;
    protected List<Pair<M, M>> modifiedMappings;
    protected List<M> deletedMappings;
    protected Set<T> allTargets;
    private Class<S> sourceCiClass;
    private Class<M> mappingCiClass;
    private Class<T> targetCiClass;
    private boolean applyDefaultMappings;

    protected Mapper(Change<Deployment> change, boolean applyDefaultMappings) {
        this.change = change;
        this.applyDefaultMappings = applyDefaultMappings;
        List actualTypeArguments = ClassUtils.getActualTypeArguments(this.getClass(), Mapper.class);
        if (actualTypeArguments.size() != 3) {
            throw new IllegalArgumentException("Not exactly three parametrized types?");
        }
        this.sourceCiClass = (Class)Preconditions.checkNotNull(actualTypeArguments.get(0));
        this.mappingCiClass = (Class)actualTypeArguments.get(1);
        this.targetCiClass = (Class)actualTypeArguments.get(2);
        this.init();
    }

    protected Mapper(Change<Deployment> change) {
        this(change, true);
    }

    protected void init() {
        this.oldMappings = this.calculateMappings(this.change.getOldRevision());
        this.newMappings = this.calculateMappings(this.change.getNewRevision());
        this.allTargets = new HashSet<T>();
        this.addedMappings = this.substractSimilarMappings(this.newMappings, this.oldMappings);
        for (Mapping mapping : this.addedMappings) {
            this.allTargets.add(mapping.getTarget());
        }
        this.modifiedMappings = this.findModifiedMappings(this.oldMappings, this.newMappings);
        for (Pair pair : this.modifiedMappings) {
            this.allTargets.add(((Mapping)pair.getFirst()).getTarget());
            this.allTargets.add(((Mapping)pair.getSecond()).getTarget());
        }
        this.deletedMappings = this.substractSimilarMappings(this.oldMappings, this.newMappings);
        for (Mapping mapping : this.deletedMappings) {
            this.allTargets.add(mapping.getTarget());
        }
    }

    public List<M> getAddedMappings() {
        return this.addedMappings;
    }

    public List<Pair<M, M>> getModifiedMappings() {
        return this.modifiedMappings;
    }

    public List<M> getDeletedMappings() {
        return this.deletedMappings;
    }

    public Set<T> getAllTargets() {
        return this.allTargets;
    }

    public Set<T> getOldTargets() {
        return this.getTargets(this.oldMappings);
    }

    public Set<T> getNewTargets() {
        return this.getTargets(this.newMappings);
    }

    private Set<T> getTargets(Collection<M> mappings) {
        HashSet<Serializable> targets = new HashSet<Serializable>();
        for (Mapping m : mappings) {
            targets.add(m.getTarget());
        }
        return targets;
    }

    public void setDefaults(Deployment deployment, M newDefaultMapping) {
    }

    private List<M> calculateMappings(Deployment deployment) {
        ArrayList mappings = new ArrayList();
        if (deployment != null) {
            Collection<S> sources = deployment.getSource().getMembersOfType(this.sourceCiClass);
            for (Serializable eachSource : sources) {
                List<M> explicitMappings = deployment.getMappingsForSource(this.mappingCiClass, eachSource);
                if (!explicitMappings.isEmpty()) {
                    this.filterExplicitMappings(mappings, explicitMappings);
                    continue;
                }
                if (!this.applyDefaultMappings) continue;
                this.generateDefaultMappingsForSource(mappings, eachSource, deployment);
            }
        }
        return mappings;
    }

    private void generateDefaultMappingsForSource(List<M> mappings, S source, Deployment deployment) {
        for (Serializable eachTarget : deployment.getTarget().getMembersOfType(this.targetCiClass)) {
            Mapping newMapping;
            try {
                newMapping = (Mapping)this.mappingCiClass.newInstance();
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            newMapping.setLabel("Default mapping from " + source + " to " + eachTarget);
            newMapping.setTarget(eachTarget);
            newMapping.setSource((Serializable)source);
            this.setDefaults(deployment, newMapping);
            mappings.add(newMapping);
        }
    }

    private void filterExplicitMappings(List<M> mappings, List<M> explicitMappings) {
        for (Mapping each : explicitMappings) {
            if (!this.targetCiClass.isInstance(each.getTarget())) continue;
            mappings.addAll(this.applySourcePropertyOverrides(explicitMappings));
        }
    }

    private List<? extends M> applySourcePropertyOverrides(List<M> mappings) {
        for (Mapping mapping : mappings) {
            if (!(mapping instanceof SourcePropertyOverridingMapping)) continue;
            Serializable copyOfsourceWithPropertiesOverridden = Mapper.applyPropertyOverrides(mapping.getSource(), ((SourcePropertyOverridingMapping)mapping).getSourcePropertyOverrides());
            mapping.setSource(copyOfsourceWithPropertiesOverridden);
        }
        return mappings;
    }

    private static Serializable applyPropertyOverrides(Serializable source, List<KeyValuePair> sourcePropertyOverrides) {
        HashMap<String, String> overrides = new HashMap<String, String>();
        if (sourcePropertyOverrides != null) {
            for (KeyValuePair override : sourcePropertyOverrides) {
                overrides.put(override.getKey(), override.getValue());
            }
        }
        try {
            return ConfigurationItemReflectionUtils.overrideProperties(source, overrides);
        }
        catch (IllegalArgumentException exception) {
            throw new ResolutionException(String.format("Invalid property override specified for %s in %s: %s", source, overrides, exception.getMessage()));
        }
    }

    private List<M> substractSimilarMappings(List<M> lhs, List<M> rhs) {
        ArrayList<Mapping> result = new ArrayList<Mapping>();
        for (final Mapping l : lhs) {
            if (CollectionUtils.exists(rhs, (Predicate)new Predicate(){

                public boolean evaluate(Object r) {
                    return l.isSimilar((Mapping)r);
                }
            })) continue;
            result.add(l);
        }
        return result;
    }

    private List<Pair<M, M>> findModifiedMappings(List<M> oldMappings, List<M> newMappings) {
        ArrayList<Pair<M, M>> modifiedMappings = new ArrayList<Pair<M, M>>();
        block0: for (Mapping l : oldMappings) {
            for (Mapping r : newMappings) {
                boolean mappingsAreSimilar = l.isSimilar(r);
                boolean mappingsAreIdentical = l.isIdentical(r);
                if (!mappingsAreSimilar || mappingsAreIdentical) continue;
                modifiedMappings.add(new Pair<Mapping, Mapping>(l, r));
                continue block0;
            }
        }
        return modifiedMappings;
    }
}

