/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.hostsession.ssh;

import com.xebialabs.deployit.ci.OperatingSystemFamily;
import com.xebialabs.deployit.exception.RuntimeIOException;
import com.xebialabs.deployit.hostsession.CommandExecutionCallbackHandler;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.ssh.SshHostSession;
import com.xebialabs.deployit.hostsession.ssh.SshSudoHostFile;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Map;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SshSudoHostSession
extends SshHostSession {
    protected String sudoUsername;
    private Logger logger = Logger.getLogger(SshSudoHostSession.class);

    public SshSudoHostSession(OperatingSystemFamily os, String temporaryDirectoryPath, String host, int port, String username, String password, String sudoUsername) {
        super(os, temporaryDirectoryPath, host, port, username, password);
        this.sudoUsername = sudoUsername;
        this.open();
    }

    @Override
    public int execute(CommandExecutionCallbackHandler handler, Map<String, String> inputResponse, String ... commandLine) throws RuntimeIOException {
        ArrayList<String> sudoCommandLine = new ArrayList<String>();
        sudoCommandLine.add("sudo");
        sudoCommandLine.add("-u");
        sudoCommandLine.add(this.sudoUsername);
        for (String arg : commandLine) {
            sudoCommandLine.add(arg);
        }
        ByteArrayInputStream input = new ByteArrayInputStream("\r\n".getBytes());
        return super.executeWithInputStream(handler, input, inputResponse, sudoCommandLine.toArray(new String[sudoCommandLine.size()]));
    }

    protected int noSudoExecute(CommandExecutionCallbackHandler handler, String ... commandLine) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"NOT adding sudo statement");
        }
        return super.execute(handler, commandLine);
    }

    @Override
    protected HostFile getFile(String hostPath, boolean isTempFile) throws RuntimeIOException {
        return new SshSudoHostFile(this, hostPath, isTempFile);
    }

    @Override
    public String toString() {
        return this.username + "@" + this.host + ":" + this.port + " (sudo to " + this.sudoUsername + ")";
    }
}

