/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.ci.security;

import com.xebialabs.deployit.ConfigurationItemProperty;
import java.io.Serializable;

public class AccessControlEntry
implements Serializable {
    @ConfigurationItemProperty(label="Group name", description="Name of the group ")
    private String groupName;
    @ConfigurationItemProperty
    private boolean canView;
    @ConfigurationItemProperty
    private boolean canModify;
    @ConfigurationItemProperty
    private boolean canRedeploy;

    public AccessControlEntry() {
    }

    public AccessControlEntry(String groupName, boolean view, boolean modify, boolean redeploy, boolean addtogroup) {
        this.groupName = groupName;
        this.canView = view;
        this.canModify = modify;
        this.canRedeploy = redeploy;
    }

    public static AccessControlEntry getNoPermissions(String groupName) {
        return new AccessControlEntry(groupName, false, false, false, false);
    }

    public static AccessControlEntry getAllPermissions(String groupName) {
        return new AccessControlEntry(groupName, true, true, true, true);
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("[");
        b.append("groupname=");
        b.append(this.getGroupName());
        b.append(" canview=");
        b.append(this.canView ? "true" : "false");
        b.append(" canmodify=");
        b.append(this.canModify ? "true" : "false");
        b.append(" canredeploy=");
        b.append(this.canRedeploy ? "true" : "false");
        b.append(" canaddtogroup=");
        b.append("]");
        return b.toString();
    }

    public void merge(AccessControlEntry aclEntryToMerge) {
        this.canView = this.canView || aclEntryToMerge.isCanView();
        this.canModify = this.canModify || aclEntryToMerge.isCanModify();
        this.canRedeploy = this.canRedeploy || aclEntryToMerge.isCanRedeploy();
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public boolean isCanView() {
        return this.canView;
    }

    public void setCanView(boolean canView) {
        this.canView = canView;
    }

    public boolean isCanModify() {
        return this.canModify;
    }

    public void setCanModify(boolean canModify) {
        this.canModify = canModify;
    }

    public boolean isCanRedeploy() {
        return this.canRedeploy;
    }

    public void setCanRedeploy(boolean canRedeploy) {
        this.canRedeploy = canRedeploy;
    }
}

