/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.hostsession.ssh;

import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.xebialabs.deployit.exception.RuntimeIOException;
import com.xebialabs.deployit.hostsession.ssh.SshHostSession;
import com.xebialabs.deployit.hostsession.ssh.SshScpHostFile;
import com.xebialabs.deployit.hostsession.ssh.SshStreamUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

class SshScpInputStream
extends InputStream {
    protected SshScpHostFile file;
    protected Session session;
    protected ChannelExec channel;
    protected InputStream channelIn;
    protected OutputStream channelOut;
    protected long bytesRemaining;
    private static final String CHANNEL_PURPOSE = " (for SCP input stream)";
    private Logger logger = Logger.getLogger(SshScpInputStream.class);

    SshScpInputStream(SshScpHostFile file) {
        this.file = file;
    }

    void open() {
        try {
            this.session = this.file.sshHostSession.openSession(CHANNEL_PURPOSE);
            this.channel = (ChannelExec)this.session.openChannel("exec");
            String command = SshHostSession.encodeCommandLine(false, "scp", "-f", this.file.remotePath);
            this.channel.setCommand(command);
            this.channelIn = this.channel.getInputStream();
            this.channelOut = this.channel.getOutputStream();
            this.channel.connect();
            this.logger.info((Object)("Executing remote command \"" + command + "\" on " + this.file.sshHostSession + " to open SCP stream for reading"));
            this.sendAck();
            this.readAck(67);
            this.readPermissions();
            this.bytesRemaining = this.readFileLength();
            this.readFilename();
            this.sendAck();
            this.logger.info((Object)("Opened SCP stream to read from remote file " + this.file));
        }
        catch (IOException exc) {
            throw new RuntimeIOException("Cannot open SCP stream to read remote file " + this.file, exc);
        }
        catch (JSchException exc) {
            throw new RuntimeIOException("Cannot open SCP stream to read remote file " + this.file, exc);
        }
    }

    private void sendAck() throws IOException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Sending ACK");
        }
        byte[] buf = new byte[]{0};
        this.channelOut.write(buf);
        this.channelOut.flush();
    }

    private void readAck(int expectedChar) {
        int c;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Reading ACK");
        }
        if ((c = SshStreamUtils.checkAck(this.channelIn)) != expectedChar) {
            throw new RuntimeIOException("Protocol error on SCP stream to read remote file " + this.file + " (remote scp command returned acked with a \"" + c + "\")");
        }
    }

    private void readPermissions() throws IOException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Reading permissions");
        }
        byte[] buf = new byte[5];
        this.channelIn.read(buf, 0, 5);
    }

    private long readFileLength() throws IOException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Reading file length");
        }
        long filelength = 0L;
        while (true) {
            int c;
            if ((c = this.channelIn.read()) < 0) {
                throw new RuntimeIOException("Protocol error on SCP stream to read remote file " + this.file);
            }
            if (c == 32) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("File length = " + filelength));
                }
                return filelength;
            }
            filelength = filelength * 10L + (long)(c - 48);
        }
    }

    private void readFilename() throws IOException {
        int c;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Reading file name");
        }
        do {
            if ((c = this.channelIn.read()) >= 0) continue;
            throw new RuntimeIOException("Protocol error on SCP stream to read remote file " + this.file);
        } while (c != 10);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.bytesRemaining > 0L) {
            int bytesRead = this.channelIn.read(b, off, (int)Math.min((long)len, this.bytesRemaining));
            this.bytesRemaining -= (long)bytesRead;
            return bytesRead;
        }
        return -1;
    }

    public int read() throws IOException {
        if (this.bytesRemaining > 0L) {
            int b = this.channelIn.read();
            if (b >= 0) {
                --this.bytesRemaining;
            }
            return b;
        }
        return -1;
    }

    public void close() {
        try {
            this.readAck(0);
            this.sendAck();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        IOUtils.closeQuietly((InputStream)this.channelIn);
        IOUtils.closeQuietly((OutputStream)this.channelOut);
        this.channel.disconnect();
        this.file.sshHostSession.disconnectSession(this.session, CHANNEL_PURPOSE);
    }
}

