/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.hostsession.ssh;

import com.xebialabs.deployit.exception.RuntimeIOException;
import com.xebialabs.deployit.hostsession.CapturingCommandExecutionCallbackHandler;
import com.xebialabs.deployit.hostsession.CommandExecutionCallbackHandler;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.ssh.SshHostFile;
import com.xebialabs.deployit.hostsession.ssh.SshHostSession;
import com.xebialabs.deployit.hostsession.ssh.SshScpInputStream;
import com.xebialabs.deployit.hostsession.ssh.SshScpOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SshScpHostFile
extends SshHostFile
implements HostFile {
    private Logger logger = Logger.getLogger(SshScpHostFile.class);

    public SshScpHostFile(SshHostSession session, String remotePath) {
        super(session, remotePath);
    }

    @Override
    public boolean exists() throws RuntimeIOException {
        return this.stat().exists;
    }

    @Override
    public boolean isDirectory() throws RuntimeIOException {
        return this.stat().isDirectory;
    }

    @Override
    public long length() throws RuntimeIOException {
        return this.stat().length;
    }

    @Override
    public boolean canRead() throws RuntimeIOException {
        return this.stat().canRead;
    }

    @Override
    public boolean canWrite() throws RuntimeIOException {
        return this.stat().canWrite;
    }

    @Override
    public boolean canExecute() throws RuntimeIOException {
        return this.stat().canExecute;
    }

    protected StatResults stat() throws RuntimeIOException {
        StatResults results = new StatResults();
        CapturingCommandExecutionCallbackHandler capturedOutput = new CapturingCommandExecutionCallbackHandler();
        int errno = this.executeCommand(capturedOutput, "ls", "-ld", this.remotePath);
        if (errno == 0) {
            results.exists = true;
            if (capturedOutput.getOutputLines().size() > 0) {
                StringTokenizer outputTokens;
                String outputLine = capturedOutput.getOutputLines().get(0);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("ls output = " + outputLine));
                }
                if ((outputTokens = new StringTokenizer(outputLine)).countTokens() < 5) {
                    throw new RuntimeIOException("ls -ld " + this.remotePath + " returned output that contains less than the expected 5 tokens");
                }
                String permissions = outputTokens.nextToken();
                String inodelinkes = outputTokens.nextToken();
                String owner = outputTokens.nextToken();
                String group = outputTokens.nextToken();
                String size = outputTokens.nextToken();
                results.isDirectory = permissions.length() >= 1 && permissions.charAt(0) == 'd';
                try {
                    results.length = Integer.parseInt(size);
                }
                catch (NumberFormatException ignore) {}
            }
        } else {
            results.exists = false;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Statted remote file " + this + " (exists=" + results.exists + ", isDirectory=" + results.isDirectory + ", length=" + results.length + ")"));
        }
        return results;
    }

    @Override
    public List<String> list() throws RuntimeIOException {
        CapturingCommandExecutionCallbackHandler capturedOutput = new CapturingCommandExecutionCallbackHandler();
        int errno = this.executeCommand(capturedOutput, "ls", "-1", this.remotePath);
        if (errno != 0) {
            throw new RuntimeIOException("Cannot list remote directory " + this + ": " + capturedOutput.getError() + " (errno=" + errno + ")");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Listed remote directory " + this));
        }
        return capturedOutput.getOutputLines();
    }

    @Override
    public void mkdir() throws RuntimeIOException {
        CapturingCommandExecutionCallbackHandler capturedOutput = new CapturingCommandExecutionCallbackHandler();
        int errno = this.executeCommand(capturedOutput, "mkdir", this.remotePath);
        if (errno != 0) {
            throw new RuntimeIOException("Cannot create remote directory " + this + ": " + capturedOutput.getError() + " (errno=" + errno + ")");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Created remote directory " + this));
        }
    }

    @Override
    public void mkdirs() throws RuntimeIOException {
        CapturingCommandExecutionCallbackHandler capturedOutput = new CapturingCommandExecutionCallbackHandler();
        int errno = this.executeCommand(capturedOutput, "mkdir", "-p", this.remotePath);
        if (errno != 0) {
            throw new RuntimeIOException("Cannot create remote directory (or parent directories) " + this + ": " + capturedOutput.getError() + " (errno=" + errno + ")");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Created remote directory and parents if necessary" + this));
        }
    }

    @Override
    protected void deleteDirectory() {
        CapturingCommandExecutionCallbackHandler capturedOutput = new CapturingCommandExecutionCallbackHandler();
        int errno = this.executeCommand(capturedOutput, "rmdir", this.remotePath);
        if (errno != 0) {
            throw new RuntimeIOException("Cannot delete remote directory " + this + ": " + capturedOutput.getError() + " (errno=" + errno + ")");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Deleted remote directory " + this));
        }
    }

    @Override
    protected void deleteFile() {
        CapturingCommandExecutionCallbackHandler capturedOutput = new CapturingCommandExecutionCallbackHandler();
        int errno = this.executeCommand(capturedOutput, "rm", this.remotePath);
        if (errno != 0) {
            throw new RuntimeIOException("Cannot delete remote file " + this + ": " + capturedOutput.getError() + " (errno=" + errno + ")");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Deleted remote file " + this));
        }
    }

    @Override
    public boolean deleteRecursively() throws RuntimeIOException {
        if (!this.exists()) {
            return false;
        }
        CapturingCommandExecutionCallbackHandler capturedOutput = new CapturingCommandExecutionCallbackHandler();
        int errno = this.executeCommand(capturedOutput, "rm", "-r", this.remotePath);
        if (errno != 0) {
            throw new RuntimeIOException("Cannot recursively delete remote directory " + this + ": " + capturedOutput.getError() + " (errno=" + errno + ")");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Recursively deleted remote file or directory " + this));
        }
        return true;
    }

    protected int executeCommand(CommandExecutionCallbackHandler handler, String ... command) {
        return this.sshHostSession.execute(handler, command);
    }

    @Override
    public InputStream get() throws RuntimeIOException {
        SshScpInputStream in = new SshScpInputStream(this);
        in.open();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Opened SCP input stream from remote file " + this));
        }
        return in;
    }

    @Override
    public OutputStream put(long length) throws RuntimeIOException {
        SshScpOutputStream out = new SshScpOutputStream(this, length);
        out.open();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Opened SCP output stream to remote file " + this));
        }
        return out;
    }

    private static class StatResults {
        public boolean exists;
        public boolean isDirectory;
        public long length = -1L;
        public boolean canRead;
        public boolean canWrite;
        public boolean canExecute;

        private StatResults() {
        }
    }
}

