/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.hostsession.common;

import com.xebialabs.deployit.hostsession.CommandExecutionCallbackHandler;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InputResponseHandler
implements CommandExecutionCallbackHandler {
    private OutputStream os;
    private Map<String, String> inputResponse;
    private CommandExecutionCallbackHandler handler;
    private StringBuffer output = new StringBuffer();
    private static Logger logger = Logger.getLogger((String)InputResponseHandler.class.getName());

    public InputResponseHandler(CommandExecutionCallbackHandler handler, OutputStream os, Map<String, String> inputResponse) {
        this.os = os;
        this.inputResponse = inputResponse;
        this.handler = handler;
    }

    @Override
    public void handleErrorLine(String line) {
        this.handler.handleErrorLine(line);
    }

    @Override
    public void handleOutput(char c) {
        this.output.append(c);
        String totalOutput = this.output.toString();
        for (String key : this.inputResponse.keySet()) {
            if (!totalOutput.endsWith(key)) continue;
            String response = this.inputResponse.get(key);
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Sending response " + response));
                }
                this.os.write(response.getBytes());
                this.os.flush();
            }
            catch (IOException e) {
                logger.error((Object)e.getMessage());
            }
        }
    }

    @Override
    public void handleOutputLine(String line) {
        this.handler.handleOutputLine(line);
    }
}

