/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.hostsession.common;

import com.xebialabs.deployit.exception.RuntimeIOException;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostSession;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.springframework.core.io.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractHostFile
implements HostFile {
    protected HostSession session;
    private static Logger logger = Logger.getLogger(AbstractHostFile.class);

    public AbstractHostFile(HostSession session) {
        this.session = session;
    }

    @Override
    public HostSession getSession() {
        return this.session;
    }

    @Override
    public HostFile getFile(String name) {
        return this.getSession().getFile(this, name);
    }

    @Override
    public HostFile getParentFile() {
        String parent = this.getParent();
        if (parent == null || parent.length() == 0) {
            return null;
        }
        return this.getSession().getFile(parent);
    }

    @Override
    public List<HostFile> listFiles() throws RuntimeIOException {
        List<String> filenames = this.list();
        if (filenames == null) {
            return null;
        }
        ArrayList<HostFile> listFiles = new ArrayList<HostFile>(filenames.size());
        for (String filename : filenames) {
            listFiles.add(this.getSession().getFile(this, filename));
        }
        return listFiles;
    }

    @Override
    public boolean deleteRecursively() throws RuntimeIOException {
        if (!this.exists()) {
            return false;
        }
        AbstractHostFile.deleteRecursivelyWithoutExistenceCheck(this);
        return true;
    }

    private static void deleteRecursivelyWithoutExistenceCheck(HostFile d) throws RuntimeIOException {
        if (d.isDirectory()) {
            List<HostFile> contents = d.listFiles();
            for (HostFile f : contents) {
                AbstractHostFile.deleteRecursivelyWithoutExistenceCheck(f);
            }
        }
        d.delete();
    }

    @Override
    public boolean deleteRecursively(String exclusion) throws RuntimeIOException {
        if (!this.exists()) {
            return false;
        }
        AbstractHostFile.deleteRecursivelyWithoutExistenceCheck(this, exclusion);
        return true;
    }

    private static void deleteRecursivelyWithoutExistenceCheck(HostFile d, String exclusion) throws RuntimeIOException {
        List<HostFile> contents;
        if (AbstractHostFile.excludeFilter(d, exclusion)) {
            return;
        }
        if (d.isDirectory()) {
            contents = d.listFiles();
            for (HostFile f : contents) {
                AbstractHostFile.deleteRecursivelyWithoutExistenceCheck(f, exclusion);
            }
        }
        if (d.isDirectory()) {
            contents = d.listFiles();
            if (contents == null || contents.size() == 0) {
                d.delete();
            }
        } else {
            d.delete();
        }
    }

    private static boolean excludeFilter(HostFile d, String exclusion) {
        String[] pieces;
        if (exclusion == null) {
            return false;
        }
        for (String piece : pieces = exclusion.split(",")) {
            if (!d.getName().equals(piece.trim())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void get(OutputStream out) throws RuntimeIOException {
        try {
            InputStream in = this.get();
            try {
                IOUtils.copy((InputStream)in, (OutputStream)out);
            }
            finally {
                IOUtils.closeQuietly((InputStream)in);
            }
        }
        catch (IOException exc) {
            throw new RuntimeIOException(exc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void get(File file) throws RuntimeIOException {
        try {
            FileOutputStream out = new FileOutputStream(file);
            try {
                this.get(out);
            }
            finally {
                ((OutputStream)out).close();
            }
        }
        catch (IOException exc) {
            throw new RuntimeIOException(exc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(InputStream in, long length) throws RuntimeIOException {
        try {
            OutputStream out = this.put(length);
            try {
                IOUtils.copy((InputStream)in, (OutputStream)out);
            }
            finally {
                IOUtils.closeQuietly((OutputStream)out);
            }
        }
        catch (IOException exc) {
            throw new RuntimeIOException(exc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(File file) throws RuntimeIOException {
        try {
            FileInputStream in = new FileInputStream(file);
            try {
                this.put(in, file.length());
            }
            finally {
                ((InputStream)in).close();
            }
        }
        catch (IOException exc) {
            throw new RuntimeIOException(exc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(Resource resource) throws RuntimeIOException {
        try {
            byte[] resourceBytes = IOUtils.toByteArray((InputStream)resource.getInputStream());
            OutputStream out = this.put(resourceBytes.length);
            try {
                IOUtils.write((byte[])resourceBytes, (OutputStream)out);
            }
            finally {
                out.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

