/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.hostsession;

import com.xebialabs.deployit.exception.RuntimeIOException;
import com.xebialabs.deployit.hostsession.HostFile;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class HostFileUtils {
    private static Logger logger = Logger.getLogger(HostFileUtils.class);

    public static void copy(HostFile src, HostFile dst) {
        if (src.isDirectory()) {
            HostFileUtils.copyDirectory(src, dst);
        } else {
            HostFileUtils.copyFile(src, dst);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(HostFile srcFile, HostFile dstFile) throws RuntimeIOException {
        HostFile destinationFile = dstFile.exists() && dstFile.isDirectory() ? dstFile.getSession().getFile(dstFile, srcFile.getName()) : dstFile;
        InputStream in = srcFile.get();
        try {
            destinationFile.put(in, srcFile.length());
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    public static void copyDirectory(HostFile srcDir, HostFile dstDir) throws RuntimeIOException {
        if (!srcDir.exists()) {
            throw new RuntimeIOException("Source directory " + srcDir + " does not exist");
        }
        if (!srcDir.isDirectory()) {
            throw new RuntimeIOException("Source directory " + srcDir + " exists but is not a directory");
        }
        if (dstDir.exists()) {
            if (!dstDir.isDirectory()) {
                throw new RuntimeIOException("Target directory " + dstDir + " already exists and is not a directory");
            }
        } else {
            dstDir.mkdirs();
        }
        List<HostFile> srcFiles = srcDir.listFiles();
        for (HostFile srcFile : srcFiles) {
            HostFile dstFile = dstDir.getFile(srcFile.getName());
            HostFileUtils.copy(srcFile, dstFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void putStringToHostFile(String sourceString, HostFile targetFile) {
        byte[] bytes;
        try {
            bytes = sourceString.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException exc) {
            throw new RuntimeIOException(exc);
        }
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        try {
            targetFile.put(in, bytes.length);
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    public static String getHostFileAsString(HostFile sourceHostFile) {
        String content;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            sourceHostFile.get(os);
            String unformattedContent = ((Object)os).toString();
            content = new String(unformattedContent.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException exc) {
            throw new RuntimeIOException(exc);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)os);
        }
        return content;
    }

    public static void unzip(HostFile zip, HostFile dir) {
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException(dir + " is not a directory");
        }
        HostFileUtils.unzip(zip.getPath(), zip.get(), dir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unzip(String zipPath, InputStream zipStream, HostFile dir) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Unzipping " + zipPath));
        }
        ZipInputStream zipIn = new ZipInputStream(zipStream);
        try {
            try {
                ZipEntry entry;
                while ((entry = zipIn.getNextEntry()) != null) {
                    HostFileUtils.uploadZipEntry(zipIn, entry, dir);
                }
            }
            catch (IOException exc) {
                throw new RuntimeIOException("Cannot unzip " + zipPath + " to " + dir, exc);
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)zipIn);
        }
    }

    private static void uploadZipEntry(ZipInputStream zipIn, ZipEntry entry, HostFile dir) {
        Object[] pathElements = StringUtils.split((String)entry.getName(), (String)"/");
        String dstFileSeparator = dir.getSession().getHostOperatingSystem().getFileSeparator();
        String dstPath = StringUtils.join((Object[])pathElements, (String)dstFileSeparator);
        HostFile dstFile = dir.getFile(dstPath);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Unzipping " + entry.getName() + " to " + dstFile.getPath()));
        }
        if (entry.isDirectory()) {
            dstFile.mkdirs();
        } else {
            dstFile.getParentFile().mkdirs();
            dstFile.put(zipIn, entry.getSize());
        }
    }
}

