/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.steps;

import com.xebialabs.deployit.ResolutionException;
import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.ci.Host;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostFileUtils;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.hostsession.HostSessionFactory;
import com.xebialabs.deployit.steps.CopyStep;
import com.xebialabs.deployit.steps.PlaceholderReplacingHostFile;
import com.xebialabs.deployit.util.TemplateResolver;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlaceholderReplacingCopyStep
extends CopyStep {
    private static final long MAX_FILE_SIZE = 0x100000L;

    public PlaceholderReplacingCopyStep(Host sourceHost, String sourceLocation, Host destinationHost, String destinationLocation, boolean createToplevelDirectory, Map<String, String> properties) {
        super(sourceHost, sourceLocation, destinationHost, destinationLocation, createToplevelDirectory, properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(StepExecutionContext ctx) {
        HostSession sourceSession = this.getHostSession();
        HostSession destinationSession = HostSessionFactory.getHostSession(this.destinationHost);
        try {
            HostFile sourceFile = sourceSession.getFile(this.sourceLocation);
            HostFile destinationFile = destinationSession.getFile(this.destinationLocation);
            boolean parentIsCreated = false;
            if (this.createToplevelDirectory && !destinationFile.exists()) {
                ctx.logOutput("Creating directory " + destinationFile);
                destinationFile.mkdirs();
                parentIsCreated = true;
            }
            this.resolveRecursively(sourceFile, destinationSession, ctx, destinationFile, parentIsCreated);
            boolean bl = true;
            return bl;
        }
        finally {
            sourceSession.close();
            destinationSession.close();
        }
    }

    private void resolveRecursively(HostFile sourceFile, HostSession destinationSession, StepExecutionContext ctx, HostFile destinationParentDir, boolean parentIsCreated) {
        if (sourceFile.isDirectory()) {
            HostFile childDestinationDir = parentIsCreated ? destinationParentDir : destinationSession.getFile(destinationParentDir.getPath() + this.destinationHost.getFileSeparator() + sourceFile.getName());
            if (!childDestinationDir.exists() && !parentIsCreated) {
                ctx.logOutput("Creating directory " + childDestinationDir);
                childDestinationDir.mkdirs();
            }
            for (HostFile child : sourceFile.listFiles()) {
                this.resolveRecursively(child, destinationSession, ctx, childDestinationDir, false);
            }
        } else {
            HostFile resolvedSimpleFile;
            if (this.properties != null && !this.properties.isEmpty()) {
                if (sourceFile.length() > 0x100000L) {
                    throw new ResolutionException("Cannot handle " + sourceFile.getName() + ".File too large(>" + 0x100000L + " bytes)");
                }
                resolvedSimpleFile = new PlaceholderReplacingHostFile(sourceFile, new TemplateResolver(this.properties));
                System.out.println("returning resolved file " + resolvedSimpleFile.getName());
            } else {
                resolvedSimpleFile = sourceFile;
            }
            ctx.logOutput("Copying " + sourceFile + " to " + destinationParentDir);
            HostFileUtils.copy(resolvedSimpleFile, destinationParentDir);
        }
    }
}

