/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.ci.mapping;

import com.xebialabs.deployit.BaseConfigurationItem;
import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.reflect.ConfigurationItemReflectionUtils;
import java.io.Serializable;

@ConfigurationItem(description="Used to specify that a certain package artifact or resource should be targeted to a specific environment member")
public class Mapping
extends BaseConfigurationItem {
    @ConfigurationItemProperty(required=true)
    private Serializable source;
    @ConfigurationItemProperty(required=true)
    private Serializable target;

    public Mapping() {
    }

    public Mapping(Serializable source, Serializable target) {
        this.label = "Mapping from " + source + " to " + target;
        this.source = source;
        this.target = target;
    }

    public Serializable getSource() {
        return this.source;
    }

    public void setSource(Serializable source) {
        this.source = source;
    }

    public Serializable getTarget() {
        return this.target;
    }

    public void setTarget(Serializable target) {
        this.target = target;
    }

    public boolean isSimilar(Mapping that) {
        boolean sourcesAreSimilar = ConfigurationItemReflectionUtils.isSimilar(this.getSource(), that.getSource());
        boolean targetsAreSimilar = ConfigurationItemReflectionUtils.isSimilar(this.getTarget(), that.getTarget());
        return sourcesAreSimilar && targetsAreSimilar;
    }

    public boolean isIdentical(Mapping that) {
        boolean sourcesAreIdentical = ConfigurationItemReflectionUtils.isIdentical(this.getSource(), that.getSource());
        boolean mappingsAreIdentical = ConfigurationItemReflectionUtils.isIdentical(this, that);
        boolean targetsAreIdentical = ConfigurationItemReflectionUtils.isIdentical(this.getTarget(), that.getTarget());
        return sourcesAreIdentical && mappingsAreIdentical && targetsAreIdentical;
    }
}

