/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.ci;

import com.xebialabs.deployit.BaseConfigurationItem;
import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.ci.DeploymentPackage;
import com.xebialabs.deployit.ci.Environment;
import com.xebialabs.deployit.ci.mapping.Mapping;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ConfigurationItem(category="deployments", description="A deployment of an application package or a deployable artifact to a middleware CI or an environment.")
public class Deployment
extends BaseConfigurationItem {
    @ConfigurationItemProperty(required=false, description="The virtual host <hostname>:<portnumber> as used by the HTTP and application server. Valid examples; www.xebialabs.com:80")
    private String vhostDefinition = null;
    @ConfigurationItemProperty(required=true)
    private DeploymentPackage source;
    @ConfigurationItemProperty(required=true)
    private Environment target;
    @ConfigurationItemProperty
    private Set<Mapping> mappings = new HashSet<Mapping>();

    public Deployment() {
    }

    public Deployment(DeploymentPackage source, Environment target) {
        this.source = source;
        this.target = target;
        this.label = "Deployment of " + source + " on " + target;
    }

    public Deployment(DeploymentPackage source, Environment target, String virtualHost) {
        this(source, target);
        this.vhostDefinition = virtualHost;
    }

    public String getVhostDefinition() {
        return this.vhostDefinition;
    }

    public void setVhostDefinition(String vhostDefinition) {
        this.vhostDefinition = vhostDefinition;
    }

    public DeploymentPackage getSource() {
        return this.source;
    }

    public void setSource(DeploymentPackage source) {
        this.source = source;
    }

    public Environment getTarget() {
        return this.target;
    }

    public void setTarget(Environment target) {
        this.target = target;
    }

    public Set<Mapping> getMappings() {
        return this.mappings;
    }

    public <M extends Mapping> List<M> getMappingsForSource(final Class<M> mappingClass, final Serializable source) {
        return (List)CollectionUtils.select(this.mappings, (Predicate)new Predicate(){

            public boolean evaluate(Object input) {
                if (!mappingClass.isInstance(input)) {
                    return false;
                }
                Mapping eachMapping = (Mapping)input;
                return eachMapping.getSource().equals(source);
            }
        });
    }

    public <M extends Mapping> List<M> getMappingsForTarget(final Class<M> mappingClass, final Serializable target) {
        return (List)CollectionUtils.select(this.mappings, (Predicate)new Predicate(){

            public boolean evaluate(Object input) {
                if (!mappingClass.isInstance(input)) {
                    return false;
                }
                Mapping eachMapping = (Mapping)input;
                return eachMapping.getTarget().equals(target);
            }
        });
    }

    public <M extends Mapping> List<M> getMappingsOfType(final Class<M> mappingClass) {
        return (List)CollectionUtils.select(this.mappings, (Predicate)new Predicate(){

            public boolean evaluate(Object input) {
                return mappingClass.isInstance(input);
            }
        });
    }

    public void setMappings(Set<Mapping> mappings) {
        this.mappings = mappings;
    }

    public void addMapping(Mapping mapping) {
        this.mappings.add(mapping);
    }
}

