/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.reflect;

import com.google.common.base.Preconditions;
import com.xebialabs.deployit.ci.artifact.DeployableArtifact;
import com.xebialabs.deployit.ci.security.PermissionScheme;
import com.xebialabs.deployit.exception.RuntimeIOException;
import com.xebialabs.deployit.reflect.ConfigurationItemDescriptor;
import com.xebialabs.deployit.reflect.ConfigurationItemDescriptorFactory;
import com.xebialabs.deployit.reflect.ConfigurationItemPropertyDescriptor;
import com.xebialabs.deployit.reflect.ConfigurationItemPropertyType;
import com.xebialabs.deployit.reflect.ConfigurationItemProxy;
import com.xebialabs.deployit.util.ExtendedFileUtils;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.BooleanUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationItemReflectionUtils {
    public static <T> T getRealConfigurationItem(T possibleCiProxy) {
        if (possibleCiProxy instanceof ConfigurationItemProxy) {
            return (T)((ConfigurationItemProxy)possibleCiProxy).getBackingObject();
        }
        return possibleCiProxy;
    }

    public static boolean isSimilar(Serializable ci1, Serializable ci2) {
        return ConfigurationItemReflectionUtils.compareProperties(ci1, ci2, true);
    }

    public static boolean isIdentical(Serializable ci1, Serializable ci2) {
        return ConfigurationItemReflectionUtils.compareProperties(ci1, ci2, false);
    }

    private static boolean compareProperties(Serializable ci1, Serializable ci2, boolean compareIdentifyingPropertiesOnly) {
        if (ci1 == null || ci2 == null) {
            return false;
        }
        ci1 = ConfigurationItemReflectionUtils.getRealConfigurationItem(ci1);
        ci2 = ConfigurationItemReflectionUtils.getRealConfigurationItem(ci2);
        ConfigurationItemDescriptor desc = ConfigurationItemDescriptorFactory.getDescriptor(ci1);
        if (desc == null) {
            throw new IllegalArgumentException("First argument is not a CI, it is of class " + ci1.getClass().getName());
        }
        ConfigurationItemDescriptor desc2 = ConfigurationItemDescriptorFactory.getDescriptor(ci2);
        if (desc2 == null) {
            throw new IllegalArgumentException("Second argument is not a CI, it is of class " + ci2.getClass().getName());
        }
        if (desc != desc2) {
            return false;
        }
        return ConfigurationItemReflectionUtils.compareProperties(desc.getPropertyDescriptors(), ci1, ci2, compareIdentifyingPropertiesOnly);
    }

    private static boolean compareProperties(ConfigurationItemPropertyDescriptor[] propertyDescriptors, Serializable ci1, Serializable ci2, boolean compareIdentifyingPropertiesOnly) {
        for (ConfigurationItemPropertyDescriptor pd : propertyDescriptors) {
            Object val2;
            Object val1;
            if (compareIdentifyingPropertiesOnly && !pd.isIdentifying() || ConfigurationItemReflectionUtils.comparePropertyValues(pd, val1 = pd.getPropertyValueFromConfigurationItem(ci1), val2 = pd.getPropertyValueFromConfigurationItem(ci2))) continue;
            return false;
        }
        return true;
    }

    private static boolean comparePropertyValues(ConfigurationItemPropertyDescriptor pd, Object val1, Object val2) {
        if (val1 == null) {
            if (val2 != null) {
                return false;
            }
        } else {
            if (val2 == null) {
                return false;
            }
            if (pd.getPropertyField().getName().equals(DeployableArtifact.NAME_OF_CONTENTS_FIELD) && pd.getPropertyField().getDeclaringClass() == DeployableArtifact.class) {
                return ConfigurationItemReflectionUtils.compareDeployableArtifactContents(val1, val2);
            }
            if (pd.getType() == ConfigurationItemPropertyType.LIST_OF_OBJECTS) {
                return ConfigurationItemReflectionUtils.compareListOfObjectsProperties(pd, val1, val2);
            }
            if (pd.getType() == ConfigurationItemPropertyType.CI || pd.getType() == ConfigurationItemPropertyType.SET_OF_CIS) {
                return true;
            }
            if (!val1.equals(val2)) {
                return false;
            }
        }
        return true;
    }

    private static boolean compareListOfObjectsProperties(ConfigurationItemPropertyDescriptor pd, Object val1, Object val2) {
        List l1 = (List)val1;
        List l2 = (List)val2;
        if (l1.size() != l2.size()) {
            return false;
        }
        for (int i = 0; i < l1.size(); ++i) {
            Serializable li1 = (Serializable)l1.get(i);
            Serializable li2 = (Serializable)l1.get(i);
            if (ConfigurationItemReflectionUtils.compareProperties(pd.getListObjectPropertyDescriptors(), li1, li2, false)) continue;
            return false;
        }
        return true;
    }

    private static boolean compareDeployableArtifactContents(Object val1, Object val2) {
        if (val1 == null || !(val1 instanceof String) || val2 == null || !(val2 instanceof String)) {
            return false;
        }
        File file1 = new File((String)val1);
        File file2 = new File((String)val2);
        try {
            return ExtendedFileUtils.contentEquals(file1, file2);
        }
        catch (IOException exc) {
            throw new RuntimeIOException("Cannot compare files " + file1 + " and " + file2, exc);
        }
    }

    public static Serializable overrideProperties(Serializable ci, Map<String, String> propertyOverrides) {
        ConfigurationItemDescriptor ciDescriptor = ConfigurationItemDescriptorFactory.getDescriptor((Serializable)Preconditions.checkNotNull((Object)(ci = ConfigurationItemReflectionUtils.getRealConfigurationItem(ci))));
        if (ciDescriptor == null) {
            throw new IllegalArgumentException("Unknown CI type " + ci.getClass());
        }
        Serializable copyOfCi = (Serializable)ciDescriptor.newInstance();
        for (ConfigurationItemPropertyDescriptor spd : ciDescriptor.getPropertyDescriptors()) {
            Object value = spd.getPropertyValueFromConfigurationItem(ci);
            spd.setPropertyValueInConfigurationItem(copyOfCi, value);
        }
        for (Map.Entry propertyOverride : ((Map)Preconditions.checkNotNull(propertyOverrides)).entrySet()) {
            ConfigurationItemPropertyDescriptor overriddenPropertyDescriptor = ciDescriptor.getPropertyDescriptor((String)propertyOverride.getKey());
            Preconditions.checkArgument((overriddenPropertyDescriptor != null ? 1 : 0) != 0);
            Preconditions.checkArgument((!overriddenPropertyDescriptor.isIdentifying() ? 1 : 0) != 0, (Object)("Unable to override an identifying property: " + overriddenPropertyDescriptor.getName()));
            overriddenPropertyDescriptor.setPropertyValueInConfigurationItem(copyOfCi, ConfigurationItemReflectionUtils.toPropertyValue(overriddenPropertyDescriptor, (String)propertyOverride.getValue()));
        }
        ConfigurationItemReflectionUtils.copyIntoLabelDescriptionAndPermissionScheme(ci, copyOfCi, ciDescriptor);
        return copyOfCi;
    }

    static void copyIntoLabelDescriptionAndPermissionScheme(Serializable sourceCi, Serializable copyOfCi, ConfigurationItemDescriptor ciDescriptor) {
        PermissionScheme psValue;
        String dValue;
        String sourceLabelValue = ciDescriptor.getLabelValueFromConfigurationItem(sourceCi);
        if (sourceLabelValue != null) {
            ciDescriptor.setLabelValueInConfigurationItem(copyOfCi, sourceLabelValue.toString());
        }
        if ((dValue = ciDescriptor.getDescriptionValueFromConfigurationItem(sourceCi)) != null) {
            ciDescriptor.setDescriptionValueInConfigurationItem(copyOfCi, dValue);
        }
        if ((psValue = ciDescriptor.getPermissionSchemeValueFromConfigurationItem(sourceCi)) != null) {
            ciDescriptor.setPermissionSchemeValueInConfigurationItem(copyOfCi, psValue);
        }
    }

    public static Object toPropertyValue(ConfigurationItemPropertyDescriptor descriptor, String value) {
        switch (descriptor.getType()) {
            case BOOLEAN: {
                return BooleanUtils.toBoolean((String)value, (String)"true", (String)"false");
            }
            case STRING: {
                return value;
            }
            case INTEGER: {
                return ConfigurationItemReflectionUtils.toInteger(value);
            }
            case ENUM: {
                return ConfigurationItemReflectionUtils.toEnumValue(descriptor.getPropertyClass(), value);
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported type: %s for property %s.%s", new Object[]{descriptor.getType(), descriptor.getPropertyField().getDeclaringClass().getName(), descriptor.getPropertyField().getName()}));
    }

    private static Integer toInteger(String value) {
        return value == null ? 0 : Integer.valueOf(value);
    }

    private static Enum<?> toEnumValue(Class<?> enumClass, String value) {
        return value == null ? null : (Enum<?>)Enum.valueOf(enumClass, value);
    }
}

