/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.hostsession.common;

import com.xebialabs.deployit.hostsession.CommandExecutionCallbackHandler;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InputResponseHandler
implements CommandExecutionCallbackHandler {
    private CommandExecutionCallbackHandler decoatedHandler;
    private OutputStream remoteStdin;
    private Map<String, String> inputResponse;
    private StringBuffer receivedOutputBuffer = new StringBuffer();
    private static Logger logger = Logger.getLogger((String)InputResponseHandler.class.getName());

    public InputResponseHandler(CommandExecutionCallbackHandler decoatedHandler, OutputStream remoteStdin, Map<String, String> inputResponse) {
        this.decoatedHandler = decoatedHandler;
        this.remoteStdin = remoteStdin;
        this.inputResponse = inputResponse;
    }

    @Override
    public void handleOutput(char c) {
        this.decoatedHandler.handleOutput(c);
        this.receivedOutputBuffer.append(c);
        String receivedOutput = this.receivedOutputBuffer.toString();
        for (String key : this.inputResponse.keySet()) {
            if (!receivedOutput.endsWith(key)) continue;
            String response = this.inputResponse.get(key);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Found prompt in output: " + receivedOutput));
            }
            try {
                this.remoteStdin.write(response.getBytes());
                this.remoteStdin.flush();
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("Sent response " + response));
            }
            catch (IOException exc) {
                logger.error((Object)("Cannot send response " + response), (Throwable)exc);
            }
        }
    }

    @Override
    public void handleOutputLine(String line) {
        this.decoatedHandler.handleOutputLine(line);
        this.receivedOutputBuffer = new StringBuffer();
    }

    @Override
    public void handleErrorLine(String line) {
        this.decoatedHandler.handleErrorLine(line);
    }
}

