/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.ci;

import com.xebialabs.deployit.BaseConfigurationItem;
import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.ci.Host;
import com.xebialabs.deployit.ci.artifact.mapping.SqlMapping;

@ConfigurationItem(description="SQL database instance", targetForMappingTypes={SqlMapping.class})
public class Database
extends BaseConfigurationItem {
    @ConfigurationItemProperty(required=true, label="Client host", description="The host on which the SQL client is running")
    private Host host;
    @ConfigurationItemProperty(required=true, label="Command", description="The plain command to the SQL client, such as \"/home/centos/oracle/product/10.2.0/db_5/bin/sqlplus\" for Oracle or \"/usr/local/mysql/bin/mysql\" for MySql", size=ConfigurationItemProperty.Size.LARGE)
    private String command;
    @ConfigurationItemProperty(required=true, label="Options", description="All options for the command, such as \"${user}/${password}@${database}\" for Oracle or \"-u ${user} -p${password} ${database}\" for MySql", size=ConfigurationItemProperty.Size.LARGE)
    private String options;
    @ConfigurationItemProperty(required=true, label="User", description="value of the user option provided to the client command, replaces \"${user}\" in options")
    private String user;
    @ConfigurationItemProperty(required=true, label="Password", description="value of the password option provided to the client command, replaces \"${password}\" in options", password=true)
    private String password;
    @ConfigurationItemProperty(required=false, label="Database", description="value of the database option provided to the client command, replaces \"${database}\" in options")
    private String database;

    public Host getHost() {
        return this.host;
    }

    public void setHost(Host host) {
        this.host = host;
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public String getOptions() {
        return this.options;
    }

    public void setOptions(String options) {
        this.options = options;
    }
}

